# -------------------------------------------------------------------------
# DESCRIPTION: 
#     The menu example from D. Young's Xt/Motif book (somewhat simplified).
#     Demonstrates how a simple popup menu can be made.
#
# USAGE: 
#     > python menu.py
#

import sys, os, Xt, Xm
import X, Xmd          # constants for Xt & Xm

# -------------------------------------------------------------------------
# Main function:

def main():	
	# Initialize and create a bulletinboard widget as the primary widget

	toplevel = Xt.Initialize('Menu', [], sys.argv )
	toplevel.SetValues( {'width': 100, 'height': 100} )
	bboard   = toplevel.CreateManagedWidget('bboard', Xm.BulletinBoard, {})

	# Create a popup menu. Add an event handler to the bulletinboard widget
	# to pop up the menu when a mouse is pressed.

	menu = bboard.CreatePopupMenu('menu', {}) 
	bboard.AddEventHandler(X.ButtonPressMask, X.FALSE, DisplayMenuEH, menu)

	# Add buttons, labels, and separators to the pane. Then register 
	# callbacks to define the action associated with each menu entry.

	void  = menu.CreateManagedWidget( 'Title', Xm.Label, {} )
	void  = menu.CreateManagedWidget( 'separator', Xm.Separator, {} )
	item1 = menu.CreateManagedWidget( 'Item1', Xm.PushButton, {} )
	item2 = menu.CreateManagedWidget( 'Item2', Xm.PushButton, {} )
	item3 = menu.CreateManagedWidget( 'Item3', Xm.PushButton, {} )

	item1.AddCallback( 'activateCallback', DoItCB, 'Item1' )
	item2.AddCallback( 'activateCallback', DoItCB, 'Item2' )
	item3.AddCallback( 'activateCallback', DoItCB, 'Item3' )

	# Realize the widgets and enter the main loop

	toplevel.RealizeWidget()
	Xt.MainLoop()

# -------------------------------------------------------------------------
# Callback functions:

def DisplayMenuEH( w, menu, event ):
	#
	# Popup the menu at the mouse position
	#
	print 'Event type is', event.type

	menu.MenuPosition( event )
	menu.ManageChild()


def DoItCB( w, client_data, call_data ):
	print client_data, 'selected'



main()
