# -------------------------------------------------------------------------
# DESCRIPTION: 
#     The memo example from D. Young's Xt/Motif book. 
#              
#     This version demonstrates the use of the translation manager. The
#     translation specifications are specified in the resource file
#     (MemoTM.resources).
#
# USAGE: 
#     > python memo_tm.py <message to be displayed>
#
# NOTE: 
#     Tranlations (keyboard shortcuts) must be specified in the resource file
#     since access to the translation manager is not supported by the Xt
#     module yet (as of 5-5-93).

import sys, os, string, Xt, Xm
import X    # constants

def CreateArgvString( argv ):
        if len(argv) > 1:
                s = string.join( argv[1:len(argv)] )
        else:
                s = 'No args'
        return s

# -------------------------------------------------------------------------
# main function
	
def main():
	# Load translation resources (keyboard shortcuts) & initialize

	void     = os.system('xrdb -nocpp -merge MemoTM.resources')
	toplevel = Xt.Initialize('MemoTM', [], sys.argv )

	# Create the XmLabel widget

	msg_widget = toplevel.CreateManagedWidget('msg', Xm.PushButton, {})

	# Create the string to be displayed

	message = CreateArgvString( sys.argv )
	message = message + '\n\nUse <key>q to quit'
	msg_widget.labelString = message

	# Add a callback
	msg_widget.AddCallback('activateCallback', quitCB, 0)

	# Realize the widgets and enter the main loop
	toplevel.RealizeWidget()
	Xt.MainLoop()

# -------------------------------------------------------------------------
# Callback function:
#
# Some widgets support callback functions. Callbacks are different than 
# event handlers because they are invoked by the widget rather than the 
# Xt intrinisics, and are not necessarily tied to any particular event. 
#
# Another difference is the 3'rd argument, which in the case of an event
# handler function is simply an XEvent structure, while in the case of a
# callback function this is a more complex structure (a union) which at
# the minimum contains the following fields:
#
# typedef struct {
#     int     reason;
#     XEvent *event;
# } XmAnyCallbackStruct;
#
	 
def quitCB(w, client_data, call_data):
	print 'quitCB called'
	# Xt.CloseDisplay(Xt.Display(w)) # not supported yet
	sys.exit(0)


main()
