# -------------------------------------------------------------------------
# DESCRIPTION: 
#     The memo example from D. Young's Xt/Motif book
#
# USAGE: 
#     > python memo.py <message to be displayed>
#

import sys, os, string, Xt, Xm

def CreateArgvString( argv ):
	if len(argv) > 1:
		s = string.join( argv[1:len(argv)] )
	else:
		s = 'No args'
	return s

# -------------------------------------------------------------------------
# main function
	
def main():

	# Initialize & create the XmLabel widget

	toplevel = Xt.Initialize('Memo', [], sys.argv )
	msg_widget = toplevel.CreateManagedWidget('msg', Xm.Label, {})

	# Create the string to be displayed

	message = CreateArgvString( sys.argv )
	msg_widget.labelString = message

	# Realize the widgets and enter the main loop

	toplevel.RealizeWidget()
	Xt.MainLoop()

main()
