# -------------------------------------------------------------------------
# DESCRIPTION: 
#     The dialog example from D. Young's Xt/Motif book. Demonstrates the use
#     of a popup dialog widget.
#
# USAGE: 
#     > python dialog.py
#

import sys, os, Xt, Xm
import X, Xmd          # constants for Xt & Xm

buttons  = [ 'button1', 'button2', 'button3' ]
editors  = [ 'field1', 'field2', 'field3' ]
help_str = [ 'Fill in the text fields and press the buttons to', \
	         'the left when done.', \
			 '', \
			 ' The first text field should contain a persons name.\n', \
			 'The second field should contain an adress.\n', \
			 'The third should contain a phone number.\n', \
			 'Edit any field and then press the done button\n', \
			 'to indicate that the information is completed.', \
			 '', \
			 'Sorry, no more help available.']

# -------------------------------------------------------------------------
# Main function:

def main():  
	# Load resources from the file "Dialog.resources", and create a 
	# toplevel shell.

	void     = os.system('xrdb -nocpp -merge Dialog.resources')
	toplevel = Xt.Initialize('Dialog', [], sys.argv )
	toplevel.SetValues( {'width': 200, 'height': 200} )
	button   = toplevel.CreateManagedWidget('push me', Xm.PushButton, {})

	# Create a popup dialog and register a callback function to pop it
	# up when the button is activated.

	dialog = CreateDialog( button )
	button.AddCallback( 'activateCallback', ShowDialogCB, dialog )

	toplevel.RealizeWidget()
	Xt.MainLoop()

# -------------------------------------------------------------------------
# CreateDialog function:

def CreateDialog( parent ):
	# A BulletinBoardDialog widget is used to hold the dialog. 
	# 
	# By default, the BulletinBoardDialog widget is set to auto-unmanage 
	# mode, which means that if any button is activated then the dialog will
	# be unmanaged. In this example we want to allow the user to activate 
	# buttons for help and so on without unmanaging the form, so the widget's 
	# 'autoUnmanage' resource is set to FALSE.

	wargs = {'autoUnmanage': X.FALSE}
	bb = parent.CreateBulletinBoardDialog( 'board', wargs )
	
	# Create 3 single line XmEdit widgets and associate a button with
	# each text widget. Assign an activateCallback to each button.

	editor = []
	for e in editors:
		editor.append( bb.CreateManagedWidget( e, Xm.Text, {} ) )

	button = []
	for i in range(3):
		button.append( bb.CreateManagedWidget( buttons[i], Xm.PushButton, {} ))
		button[i].AddCallback( 'activateCallback', GetTextCB, editor[i] )

	# Add a button to let the user pop down the widget

	done_button = bb.CreateManagedWidget( 'done', Xm.PushButton, {} )
	done_button.AddCallback( 'activateCallback', DoneCB, bb )

	# Add help button to let the user ask for help

	help_button = bb.CreateManagedWidget( 'help', Xm.PushButton, {} )
	help_button.AddCallback( 'activateCallback', HelpCB, help_str )

	return bb


# -------------------------------------------------------------------------
# Callback functions:

def GetTextCB( w, textwidget, call_data ):
	str = textwidget.TextGetString()
	print str

def ShowDialogCB( w, dialog, call_data ):
	dialog.ManageChild()

def HelpCB( w, help_str, call_data ):
	# A MessageDialog widget is used to display the help

	wargs = {'autoUnmanage': X.FALSE}
	dialog = w.CreateMessageDialog( 'Help', wargs )
	
	# We won't be using the cancel widget. Unmanage it.

	cancel = dialog.MessageBoxGetChild( Xmd.DIALOG_CANCEL_BUTTON )
	cancel.UnmanageChild()

	# Retrieve the label widget and make the text left-justified

	label = dialog.MessageBoxGetChild( Xmd.DIALOG_MESSAGE_LABEL )
	label.alignment = Xmd.ALIGNMENT_BEGINNING

	# Add an OK callback to pop down the dialog

	dialog.AddCallback( 'okCallback', OkCB, 0 )

	# Use the text in help_str up to the first null string as the help text
 
	import string
	if '' in help_str:
		i = help_str.index('')
		s = string.join( help_str[0:i] )
		dialog.messageString = s

		# add a help callback for the next entry in the help string
		
		dialog.AddCallback('helpCallback', HelpCB, help_str[i+1:len(help_str)])
	else:
		# this was the last help message

		s = string.join( help_str )
		dialog.messageString = s

		# unmanage the help button so that the user cannot request more help

		help = dialog.MessageBoxGetChild( Xmd.DIALOG_HELP_BUTTON )
		help.UnmanageChild()

	# display the dialog

	dialog.ManageChild()

	
def DoneCB( w, dialog, call_data ):
	dialog.UnmanageChild()

def OkCB( w, client_data, call_data ):
	w.UnmanageChild()

	
main()
