import Xt
import string
import sys

flush = sys.stdout.flush

alltypes = {}

def table(top, m):
	names = dir(m)
	wclasstype = type(top.Class())
	for name in names:
		wc = getattr(m, name)
		if type(wc) <> wclasstype: continue
		print name + '...',
		flush()
		list = wc.GetResourceList()
		addtolist(list, name)
		print
		flush()

def addtolist(list, wname):
	for i in range(len(list)):
		item = list[i]
		name, cls, type, size, offset, deftype, defval = item
		if size > 4: print `item`, wname
		if type == '': print `item`, wname
		if not alltypes.has_key(type): alltypes[type] = []
		alltypes[type].append(wname)

if sys.argv[1:]:
	top = Xt.Initialize('Table', [], sys.argv)
	for arg in sys.argv[1:]:
		if arg == 'xm':
			import Xm
			table(top, Xm)
		elif arg == 'xaw':
			import Xaw
			table(top, Xaw)
		elif arg == 'xt':
			table(top, Xt)
		elif arg == 'glx':
			import Glx
			table(top, Glx)
		elif arg == 'html':
			import HTML
			table(top, HTML)
		else:
			print 'Don\'t know how to print', `arg`
	list = alltypes.keys()
	list.sort()
	for item in list: print '"%s",' % item
