# Play with geometry management

import os
import sys

import Xt
import Xm
import Xmd

def vpile(form, children):
	return pile(form, children, Xmd.VERTICAL)

def hpile(form, children):
	return pile(form, children, Xmd.HORIZONTAL)

def pile(form, children, orientation):
	if not children:
		return			# nothing to do
	# test that children belong here before doing anything
	for child in children:
		if child.Parent() is not form:
			raise ValueError, 'widget not a child of given form'
	# set up orientation-dependent constants
	if orientation == Xmd.VERTICAL:
		LEFT = 'left'
		RIGHT = 'right'
		TOP = 'top'
		BOTTOM = 'bottom'
	else:
		LEFT = 'top'
		RIGHT = 'bottom'
		TOP = 'left'
		BOTTOM = 'right'
	# now attach widgets to each other and to the form
	n = len(children)
	for i in range(n):
		child = children[i]
		args = {}
		args[LEFT + 'Attachment'] = Xmd.ATTACH_FORM
		args[RIGHT + 'Attachment'] = Xmd.ATTACH_FORM
		if i <= 0:
			args[TOP + 'Attachment'] = Xmd.ATTACH_FORM
		else:
			args[TOP + 'Attachment'] = Xmd.ATTACH_WIDGET
			args[TOP + 'Widget'] = children[i-1]
		if i+1 >= n:
			args[BOTTOM + 'Attachment'] = Xmd.ATTACH_FORM
		child.SetValues(args)
		child.ManageChild()

def main():
	shell = Xt.Initialize()
	form = shell.CreateForm('form', {})
	c1 = form.CreateLabel('label1', {})
	c2 = form.CreatePushButton('pushbutton1', {})
	c3 = form.CreateToggleButton('togglebutton1', {})
	c3.selectColor = 'yellow'
	c4 = form.CreateForm('subform', {})
	c4c = []
	for s in 'aap', 'noot', 'mies\nwim zus', 'jet':
		args = {}
		args['indicatorType'] = Xmd.ONE_OF_MANY
		c = c4.CreateToggleButton(s, args)
		c.selectColor = 'red'
		c4c.append(c)
	vpile(c4, c4c)
	children = [c1, c2, c3, c4]
	hpile(form, children)
	form.ManageChild()
	shell.RealizeWidget()
	Xt.MainLoop()

main()
