import GenericAudioSource
import sys
import time
import audioop

import Xt
import Xm

def main():
	toplevel = Xt.Initialize('scanaudio', [], sys.argv)
	#
	if sys.argv[1:]:
		if sys.argv[2:]:
			print 'usage: scanaudio [file]'
			sys.exit(2)
		file = sys.argv[1]
	else:
		file = '/usr/local/sounds/aiff/again.aiff'
	#
	source = GenericAudioSource.open(file)
	#
	vector = []
	area = toplevel.CreateDrawingArea('area',
		  {'width':400, 'height':200})
	area.AddCallback('exposeCallback', cb_expose, (vector, source))
	area.AddCallback('resizeCallback', cb_resize, (vector, source))
	area.ManageChild()
	#
	toplevel.RealizeWidget()
	#
	sampwidth = source.getsampwidth()
	nch = source.getnchannels()
	nfr = source.getnframes()
	rate = source.getframerate()
	#
	print 'Duration:', '%.3f' % (float(nfr) / rate)
	print 'Channels:', nch
	print 'Width   :', sampwidth
	print 'Rate    :', source.getframerate()
	#
	Xt.MainLoop()

def cb_expose(widget, (vector, source), call_data):
	if not vector:
		calcvector(vector, widget, source)
		if not vector:
			return
	g = widget.GetGC({})
	if type(vector[0]) == type(0):
		y = widget.height/2
		for x in range(len(vector)):
			v = vector[x]
			g.DrawLine(x, y-v, x, y+v)
	else:
		yl = widget.height*1/4
		yr = widget.height*3/4
		for x in range(len(vector)):
			vl, vr = vector[x]
			g.DrawLine(x, yl-vl, x, yl+vl)
			g.DrawLine(x, yr-vr, x, yr+vr)

def cb_resize(widget, (vector, source), call_data):
	calcvector(vector, widget, source)

def calcvector(vector, area, source):
	xscale = area.width
	yscale = area.height
	sampwidth = source.getsampwidth()
	sampbits = source.getsampbits()
	nch = source.getnchannels()
	nfr = source.getnframes()
	chunksize = max(1, (nfr+xscale-1)/xscale)
	source.rewind()
	vector[:] = [None]*xscale
	if nch == 2:
		scale = 1<<(sampbits+1)
		for i in range(xscale):
			chunk = source.readframes(chunksize)
			if not chunk:
				del vector[i:]
				break
			left = audioop.tomono(chunk, 2, 1, 0)
			right = audioop.tomono(chunk, 2, 0, 1)
			lmax = audioop.max(left, sampwidth) * yscale / scale
			rmax = audioop.max(right, sampwidth) * yscale / scale
			vector[i] = (lmax, rmax)
	else:
		scale = 1<<sampbits
		for i in range(xscale):
			chunk = source.readframes(chunksize)
			if not chunk:
				del vector[i:]
				break
			vector[i] = \
			    audioop.max(chunk, sampwidth) * yscale / scale

main()
