# A video source based upon VFile.

import sys
sys.path.append('/ufs/guido/src/video')

from VFile import RandomVinFile

class VideoSource(RandomVinFile):

	def __init__(self, filename):
		self.__init__(filename)
		self.warmcache()
		self.framepos = 0

	def getsourceparams(self):
		return self.getinfo()

	# Reverse motion:

	def getprevframe(self):
		i = self.framecount - 2
		if i < 0: raise EOFError
		return self.getrandomframe(i)

	# Positioning uses milliseconds as addressing!

	def getframerate(self):
		return 1000

	def getnframes(self):
		if not self.index:
			return 0
		return self.index[-1][0][0] + 1

	def tell(self):
		if self.framecount >= len(self.index):
			return self.index[-1][0][0] + 1
		if self.framecount <= 0:
			return 0
		return self.index[self.framecount - 1][0][0]

	def seek(self, pos):
		i = 0
		while i < len(self.index):
			if self.index[i][0][0] > pos:
				break
			i = i+1
		if i <= 0:
			self.rewind()
		else:
			t, ds, cs = self.getrandomframeheader(i-1)
			self.skipnextframedata(ds, cs)

# For testing, see VideoPlayer.
