# Raw U-LAW audio source.

def open(file, *args):
	if args not in [(), ('r',)]: raise TypeError, 'bad args'
	return ULAWAudioSource(file)

def openfp(fp, *args):
	if args not in [(), ('r',)]: raise TypeError, 'bad args'
	return ULAWAudioSource('<nameless>', fp)

import __builtin__
import os
from stat import *
from BaseAudioSource import BaseAudioSource, Error

class ULAWAudioSource(BaseAudioSource):

	def __init__(self, file, *args):
		self.file = file
		if args:
			if len(args) > 1:
				raise TypeError, 'too many args'
			self.fp = args[0]
		else:
			self.fp = __builtin__.open(file, 'r')
		st = os.fstat(self.fp.fileno())
		self.size = st[ST_SIZE]

	# (Most functions are inherited from BaseAudioSource)

	def getsampformat(self): return 'ulaw'

	def getnframes(self): return self.size

	def readframes(self, n): return self.fp.read(n)

	def seek(self, pos): self.fp.seek(pos)

	def tell(self): return self.fp.tell()
