import sunaudiodev
import audioop

BUFFERSIZE = 8192

Error = 'SunAudioSink.Error'

class SunAudioSink:

	def __init__(self, *args):
		if args:
			if args[1:]: raise TypeErrors, 'too many args'
			self.setsourceparams(args[0])

	def __del__(self):
		self.close()

	def close(self):
		try:
			try:
				self.__fp.flush()
				self.__fp.close()
			except:
				pass
		finally:
			self.__fp = None

	def getfilled(self):
		if self.__fp:
			return self.__fp.obufcount()
		else:
			return 0

	def getfillable(self):
		if self.__fp:
			return BUFFERSIZE - self.__fp.obufcount()
		else:
			return BUFFERSIZE

	def reset(self):
		left = self.getfilled()
		self.close()
		return left

	def writeframes(self, data):
		if self.__converter:
			data = self.__converter(data)
		self.__fp.write(data)

	def setsourceparams(self, params):
		fmt, bytes, bits, nch, rate, nfr = params
		if not (8000 <= rate <= 8012): 
			raise Error, 'only 8000 frames/sec is supported'
		if nch <> 1:
			raise Error, 'only one channel is supported'
		if fmt == 'ulaw':
			self.__converter = None
			self.__bytes = 0
		elif fmt == 'linear':
			self.__converter = self.__lin2ulaw
			self.__bytes = bytes
		# (Re)open the device
		self.__fp = None
		self.__fp = sunaudiodev.open('w')

	def __lin2ulaw(self, data):
		return audioop.lin2ulaw(data, self.__bytes)
