# Open any recognized sound file as sound source

def open(file):
	hdr = whatsound.what(file)
	if not hdr:
		raise Error, 'unrecognized file type'
	type = hdr[0]
	if type in ('aifc', 'aiff'):
		import AIFCAudioSource
		return AIFCAudioSource.open(file)
	if type == 'au':
		import SndAudioSource
		return SndAudioSource.open(file)
	if type == 'ul':
		import ULAWAudioSource
		return ULAWAudioSource.open(file)
	raise Error, 'unsupported audio file type (%s)' % type

import whatsound
from BaseAudioSource import Error

def test():
	# See AudioPlayer for a test involving readframes(), seek() and tell()
	import sys, time
	files = sys.argv[1:]
	if not files:
		files.append('/usr/local/sounds/au/klaxon.au')
		files.append('/usr/local/sounds/aiff/again.aiff')
		files.append('/usr/local/sounds/voc/homer.voc')
		files.append('/etc/passwd')
		files.append('/dev/null')
	for file in files:
		print file,
		try:
			x = open(file)
		except Error, msg:
			print msg
			continue
		print x.getsourceparams()
