import Window

class Editor:
	_numeditor = 0

	def __init__(self):
		w = Window.Window('editor', resizable = 1)
		m = w.PulldownMenu([('File', [('New...', (self.new, ())),
					      None,
					      ('Open...', (self.open, ())),
					      ('Save', (self.save, ())),
					      ('SaveAs...', (self.saveas, ())),
					      None,
					      ('Close', (self.close, ())),
					      ('Exit', (self.quit, ()))])],
				   top = None, left = None, right = None)
		t = w.TextEdit('', None, top = m, bottom = None,
			       left = None, right = None)
		self.window = w
		self.dwindow = w
		self.text = t
		w.show()
		Editor._numeditor = Editor._numeditor + 1
		if Editor._numeditor == 1:
			Window.Mainloop()

	def new(self):
		w = Editor()

	def close(self):
		self.window.close()
		del self.window, self.dwindow, self.text
		Editor._numeditor = Editor._numeditor - 1
		if Editor._numeditor == 0:
			self.quit()

	def open(self):
		self.dwindow = Window.FileDialog(grab = self.window,
						 cb_ok = self.opencb)

	def opencb(self, filename):
		try:
			f = open(filename)
		except IOError, msg:
			Window.Message('Cannot open %s: %s' % (filename, msg[1]),
				       grab = self.dwindow, mtype = 'error')
			return 1
		self.dwindow = self.window
		self.filename = filename
		self.window.settitle(filename)
		self.text.settext(f.read())
		f.close()

	def save(self):
		self.savefile(self.filename)

	def saveas(self):
		self.dwindow = Window.FileDialog(grab = self.window,
						 cb_ok = self.savefile)

	def savefile(self, filename):
		try:
			f = open(filename, 'w')
		except IOError, msg:
			Window.Message('Cannot open %s: %s'%(filename,msg[1]),
				       grab = self.dwindow, mtype = 'error')
			return 1
		self.dwindow = self.window
		self.filename = filename
		self.window.settitle(filename)
		f.write(self.text.gettext())
		f.close()

	def quit(self):
		raise SystemExit, 0

e = Editor()
