#include "stdafx.h"
#include <math.h>
#include <io.h>
#include <ctype.h>
#include <direct.h>
#include <errno.h>
#include "app.h"
#include "image.h"

/* Missing ??  Needed for isspace() ?? */
#define UCHAR(c)	(c)

#ifdef MS_WIN16
#include <memory.h>
#define LPSTR	char huge*
#define HUGE	huge
#else
#define HUGE
#endif

#define DIB_HEADER_MARKER   ((WORD) ('M' << 8) | 'B')
#define IS_WIN30_DIB(lpbi)  ((*(LPDWORD)(lpbi)) == sizeof(BITMAPINFOHEADER))

CWpyImage::CWpyImage(PyObject *pyobj)
{
	theApp.RecordObjects(this, pyobj, FALSE);
	m_hDIB = 0;
	m_palDIB = 0;
}

CWpyImage::~CWpyImage()
{
	if (m_palDIB != NULL)
	{
		delete m_palDIB;
		m_palDIB = NULL;
	}
	theApp.UnRecordCpp(this, FALSE);
}

BOOL CWpyImage::ReadImageFile(LPCTSTR name)
{
	int i, start = strlen(name) - 4;
	if (start > 0 && name[start] == '.'){
		start++;
		i = start;
		if ((name[i] == 'g' || name[i] == 'G') &&
		(name[++i] == 'i' || name[i] == 'I') &&
		(name[++i] == 'f' || name[i] == 'F'))
			return ReadImageFileGIF(name);
		i = start;
		if ((name[i] == 'p' || name[i] == 'P') &&
		(name[++i] == 'p' || name[i] == 'P') &&
		(name[++i] == 'm' || name[i] == 'M'))
			return ReadImageFilePPM(name);
	}
	return ReadImageFileDIB(name);
}

BOOL CWpyImage::ReadImageFileDIB(LPCTSTR lpszPathName)
{
	CFile file;
	CFileException fe;

	if (!file.Open(lpszPathName, CFile::modeRead, &fe))
	{
		return FALSE;
	}

	BITMAPFILEHEADER bmfHeader;
	DWORD dwBitsSize;
	LPSTR pDIB;

	// BeginWaitCursor();

	dwBitsSize = file.GetLength();

	if (file.Read((LPSTR)&bmfHeader, sizeof(bmfHeader)) != sizeof(bmfHeader))
		return FALSE;

	if (bmfHeader.bfType != DIB_HEADER_MARKER)
		return FALSE;

	m_hDIB = (HDIB) ::GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT, dwBitsSize);
	if (m_hDIB == 0)
	{
		return FALSE;
	}
	pDIB = (LPSTR) ::GlobalLock((HGLOBAL) m_hDIB);

	if (file.ReadHuge(pDIB, dwBitsSize - sizeof(BITMAPFILEHEADER)) !=
		dwBitsSize - sizeof(BITMAPFILEHEADER) )
	{
		::GlobalUnlock((HGLOBAL) m_hDIB);
		::GlobalFree((HGLOBAL) m_hDIB);
		return FALSE;
	}
	::GlobalUnlock((HGLOBAL) m_hDIB);

	if (m_palDIB != NULL)
	{
		delete m_palDIB;
		m_palDIB = NULL;
	}

	// Set up bitmap size, number of colors, etc.
	LPSTR lpDIB = (LPSTR) ::GlobalLock((HGLOBAL) m_hDIB);
	if (!lpDIB)
		return FALSE;
	LPBITMAPINFOHEADER lpbmi;  // pointer to a Win 3.0-style DIB
	LPBITMAPCOREHEADER lpbmc;  // pointer to an other-style DIB
	lpbmi = (LPBITMAPINFOHEADER)lpDIB;
	lpbmc = (LPBITMAPCOREHEADER)lpDIB;
	if (IS_WIN30_DIB(lpDIB)){
		m_sizeDIB = CSize((int)lpbmi->biWidth, (int)labs(lpbmi->biHeight));
		m_numColors = lpbmi->biClrUsed;
		if (!m_numColors)
			m_numColors = ColorsFromBitCount(lpbmi->biBitCount);
		m_offsetToBits = *(LPDWORD)lpDIB + (WORD)(m_numColors * sizeof(RGBQUAD));
	}
	else {
		m_sizeDIB = CSize(lpbmc->bcWidth, abs(lpbmc->bcHeight));
		m_numColors = ColorsFromBitCount(lpbmc->bcBitCount);
		m_offsetToBits = *(LPDWORD)lpDIB + (WORD)(m_numColors * sizeof(RGBTRIPLE));
	}
	::GlobalUnlock((HGLOBAL) m_hDIB);

	// Create copy of palette
	m_palDIB = new CPalette;
	if (m_palDIB == NULL)
	{
		::GlobalFree((HGLOBAL) m_hDIB);
		m_hDIB = NULL;
		return TRUE;
	}
	if (CreateDIBPalette(m_hDIB, m_palDIB) == NULL)
	{
		delete m_palDIB;
		m_palDIB = NULL;
		return TRUE;
	}

	// EndWaitCursor();

	return TRUE;
}

BOOL CWpyImage::PaintDIB(CDC * pDC, CRect& dest)
{
	if (m_hDIB == NULL)
		return FALSE;

	HDC hDC = pDC->m_hDC;
	int widthDest = dest.right - dest.left;
	int heightDest = dest.bottom - dest.top;
	int x = dest.left;
	int y = dest.top;
	UINT lines = m_sizeDIB.cy;

	BOOL bSuccess=FALSE;
	HPALETTE hPal=NULL;
	HPALETTE hOldPal=NULL;

	LPSTR lpDIBHdr  = (LPSTR) ::GlobalLock((HGLOBAL) m_hDIB);
	LPSTR lpDIBBits = lpDIBHdr + m_offsetToBits;

	if (m_palDIB != NULL)
	{
		hPal = (HPALETTE) m_palDIB->m_hObject;
		hOldPal = ::SelectPalette(hDC, hPal, TRUE);
	}

	//::SetStretchBltMode(hDC, COLORONCOLOR);

	if ((widthDest  == m_sizeDIB.cx) &&
	   (heightDest == m_sizeDIB.cy))
	bSuccess = ::SetDIBitsToDevice(hDC,
				   x,
				   y,
				   widthDest,
				   heightDest,
				   0,
				   0,
				   0,
				   lines,
				   lpDIBBits,
				   (LPBITMAPINFO)lpDIBHdr,
				   DIB_RGB_COLORS);
   else
	bSuccess = ::StretchDIBits(hDC,
				   x, 
				   y,
				   widthDest,
				   heightDest,
				   0,
				   0,
				   m_sizeDIB.cx,
				   m_sizeDIB.cy,
				   lpDIBBits,
				   (LPBITMAPINFO)lpDIBHdr,                        
				   DIB_RGB_COLORS,
				   SRCCOPY);

   ::GlobalUnlock((HGLOBAL) m_hDIB);

	if (hOldPal != NULL)
	{
		::SelectPalette(hDC, hOldPal, TRUE);
	}

   return bSuccess;
}

BOOL CWpyImage::CreateDIBPalette(HDIB hDIB, CPalette* pPal)
{
	if (hDIB == NULL)
	  return FALSE;

	LPLOGPALETTE lpPal;
	HANDLE hLogPal;
	HPALETTE hPal = NULL;
	BOOL bWinStyleDIB;
	BOOL bResult = FALSE;

	LPSTR lpbi = (LPSTR) ::GlobalLock((HGLOBAL) hDIB);
	LPBITMAPINFO lpbmi = (LPBITMAPINFO)lpbi;
	LPBITMAPCOREINFO lpbmc = (LPBITMAPCOREINFO)lpbi;

	if (m_numColors != 0)
	{
		hLogPal = ::GlobalAlloc(GHND, sizeof(LOGPALETTE)
									+ sizeof(PALETTEENTRY)
									* m_numColors);
		if (hLogPal == 0)
		{
			::GlobalUnlock((HGLOBAL) hDIB);
			return FALSE;
		}

		lpPal = (LPLOGPALETTE) ::GlobalLock((HGLOBAL) hLogPal);
		lpPal->palVersion = 0x300;
		lpPal->palNumEntries = (unsigned short)m_numColors;

		bWinStyleDIB = IS_WIN30_DIB(lpbi);
		int i;
		for (i = 0; i < m_numColors; i++)
		{
			if (bWinStyleDIB)
			{
				lpPal->palPalEntry[i].peRed = lpbmi->bmiColors[i].rgbRed;
				lpPal->palPalEntry[i].peGreen = lpbmi->bmiColors[i].rgbGreen;
				lpPal->palPalEntry[i].peBlue = lpbmi->bmiColors[i].rgbBlue;
				lpPal->palPalEntry[i].peFlags = 0;
			}
			else
			{
				lpPal->palPalEntry[i].peRed = lpbmc->bmciColors[i].rgbtRed;
				lpPal->palPalEntry[i].peGreen = lpbmc->bmciColors[i].rgbtGreen;
				lpPal->palPalEntry[i].peBlue = lpbmc->bmciColors[i].rgbtBlue;
				lpPal->palPalEntry[i].peFlags = 0;
			}
		}

		bResult = pPal->CreatePalette(lpPal);
		::GlobalUnlock((HGLOBAL) hLogPal);
		::GlobalFree((HGLOBAL) hLogPal);
	}
	::GlobalUnlock((HGLOBAL) hDIB);
	return bResult;
}

int CWpyImage::ColorsFromBitCount(int bitCount)
{
	switch (bitCount)
	{
		case 1:
			return 2;

		case 4:
			return 16;

		case 8:
			return 256;

		default:
			return 0;
	}
}
/*
 * tkImgFmtGIF.c --
 *
 * A photo image file handler for GIF files. Reads 87a and 89a GIF files.
 * At present there is no write function.
 *
 * Derived from the giftoppm code found in the pbmplus package 
 * and tkImgFmtPPM.c in the tk4.0b2 distribution by -
 *
 * Reed Wade (wade@cs.utk.edu), University of Tennessee
 *
 * Copyright (c) 1995 Sun Microsystems, Inc.
 *
 * [Original file license.terms follows:]
 * This software is copyrighted by the Regents of the University of
 * California, Sun Microsystems, Inc., and other parties.  The following
 * terms apply to all files associated with the software unless explicitly
 * disclaimed in individual files.
 * 
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 * Modifications to this software may be copyrighted by their authors
 * and need not follow the licensing terms described here, provided that
 * the new terms are clearly indicated on the first page of each file where
 * they apply.
 * 
 * IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY
 * DERIVATIVES THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE
 * IS PROVIDED ON AN "AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE
 * NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
 * MODIFICATIONS.
 * 
 * RESTRICTED RIGHTS: Use, duplication or disclosure by the government
 * is subject to the restrictions as set forth in subparagraph (c) (1) (ii)
 * of the Rights in Technical Data and Computer Software Clause as DFARS
 * 252.227-7013 and FAR 52.227-19.
 *
 * [End of license.terms]
 * This file also contains code from the giftoppm program, which is
 * copyrighted as follows:
 *
 * +-------------------------------------------------------------------+
 * | Copyright 1990, David Koblas.                                     |
 * |   Permission to use, copy, modify, and distribute this software   |
 * |   and its documentation for any purpose and without fee is hereby |
 * |   granted, provided that the above copyright notice appear in all |
 * |   copies and that both that copyright notice and this permission  |
 * |   notice appear in supporting documentation.  This software is    |
 * |   provided "as is" without express or implied warranty.           |
 * +-------------------------------------------------------------------+
 */

static char sccsid[] = "@(#) tkImgFmtGIF.c 1.3 95/06/14 22:49:02";

#define _ANSI_ARGS_(x)	x
#define TCL_OK		0
#define TCL_ERROR	1

#define INTERLACE		0x40
#define LOCALCOLORMAP		0x80
#define BitSet(byte, bit)	(((byte) & (bit)) == (bit))
#define MAXCOLORMAPSIZE		256
#define CM_RED			2
#define CM_GREEN		1
#define CM_BLUE			0
#define MAX_LWZ_BITS		12
#define LM_to_uint(a,b)         (((b)<<8)|(a))
#define ReadOK(file,buffer,len)	(fread(buffer, len, 1, file) != 0)

/*
 * Prototypes for local procedures defined in this file:
 */

static int		DoExtension _ANSI_ARGS_((FILE *fd, int label,
			    int *transparent));
static int		GetCode _ANSI_ARGS_((FILE *fd, int code_size,
			    int flag));
static int		GetDataBlock _ANSI_ARGS_((FILE *fd,
			    unsigned char *buf));
static int		LWZReadByte _ANSI_ARGS_((FILE *fd, int flag,
			    int input_code_size));
static int		ReadColorMap _ANSI_ARGS_((FILE *fd, int number,
			    unsigned char buffer[3][MAXCOLORMAPSIZE]));
static int		ReadGIFHeader _ANSI_ARGS_((FILE *f, int *widthPtr,
			    int *heightPtr));
static int		ReadImage _ANSI_ARGS_((
			    unsigned char HUGE *imagePtr, FILE *fd, int len, int height,
			    unsigned char cmap[3][MAXCOLORMAPSIZE],
			    int interlace, int transparent));

/*
 *----------------------------------------------------------------------
 *
 * FileReadGIF --
 *
 *	This procedure is called by the photo image type to read
 *	GIF format data from a file and write it into a given
 *	photo image.
 *
 * Results:
 *	A standard TCL completion code.  If TCL_ERROR is returned
 *	then an error message is left in interp->result.
 *
 * Side effects:
 *	The access position in file f is changed, and new data is
 *	added to the image given by imageHandle.
 *
 *----------------------------------------------------------------------
 */

BOOL CWpyImage::ReadImageFileGIF(LPCTSTR fileName)
{
	CStdioFile file;
	CFileException fe;

	if (!file.Open(fileName, CFile::modeRead | CFile::typeBinary, &fe))
	{
		return FALSE;
	}
	FILE *f = file.m_pStream;

    int fileWidth, fileHeight;
    unsigned char buf[100];
    int bitPixel;
    unsigned int colorResolution;
    unsigned int background;
    unsigned int aspectRatio;
    unsigned char localColorMap[3][MAXCOLORMAPSIZE];
    unsigned char colorMap[3][MAXCOLORMAPSIZE];
    int useGlobalColormap;
    int transparent = -1;

    if (!ReadGIFHeader(f, &fileWidth, &fileHeight)) {
	//Tcl_AppendResult(interp, "couldn't read GIF header from file \"",
	//	fileName, "\"", NULL);
	return FALSE;
    }
    if ((fileWidth <= 0) || (fileHeight <= 0)) {
	//Tcl_AppendResult(interp, "GIF image file \"", fileName,
	//	"\" has dimension(s) <= 0", (char *) NULL);
	return FALSE;
    }

    if (fread(buf, 1, 3, f) != 3) {
	return TRUE;
    }
    bitPixel = 2<<(buf[0]&0x07);
    colorResolution = (((buf[0]&0x70)>>3)+1);
    background = buf[1];
    aspectRatio = buf[2];

    if (BitSet(buf[0], LOCALCOLORMAP)) {    /* Global Colormap */
	if (!ReadColorMap(f, bitPixel, colorMap)) {
	    //Tcl_AppendResult(interp, "error reading color map",
		//    (char *) NULL);
	    return FALSE;
	}
    }

	// Allocate memory for DIB
	m_hDIB = (HDIB) ::GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT,
		sizeof(BITMAPINFOHEADER) + (long)fileWidth * fileHeight * 3);
	if (m_hDIB == 0)
	{
		return FALSE;
	}
	BITMAPINFOHEADER * pDIB = (BITMAPINFOHEADER *) ::GlobalLock((HGLOBAL) m_hDIB);
    unsigned char HUGE * pPixels = (unsigned char HUGE *)pDIB + sizeof(BITMAPINFOHEADER);

    m_offsetToBits = pDIB->biSize = sizeof(BITMAPINFOHEADER);
    pDIB->biWidth = fileWidth;
#ifdef MS_WIN16
    pDIB->biHeight = fileHeight;
#else
    pDIB->biHeight = - fileHeight;	// Automatic invert of image
#endif
	m_sizeDIB = CSize(fileWidth, fileHeight);
	m_numColors = 0;
    pDIB->biPlanes = 1;
    pDIB->biBitCount = 24;
    pDIB->biCompression = BI_RGB;
    pDIB->biSizeImage = 0;
    pDIB->biXPelsPerMeter = 0;
    pDIB->biYPelsPerMeter = 0;
    pDIB->biClrUsed = 0;
    pDIB->biClrImportant = 0;

    while (1) {
	if (fread(buf, 1, 1, f) != 1) {
	    /*
	     * Premature end of image.  We should really notify
	     * the user, but for now just show garbage.
	     */

	    break;
	}

	if (buf[0] == ';') {
	    /*
	     * GIF terminator.
	     */

	    break;
	}

	if (buf[0] == '!') {
	    /*
	     * This is a GIF extension.
	     */

	    if (fread(buf, 1, 1, f) != 1) {
		//interp->result =
		//	"error reading extension function code in GIF image";
		goto error;
	    }
	    if (DoExtension(f, buf[0], &transparent) < 0) {
		//interp->result = "error reading extension in GIF image";
		goto error;
	    }
	    continue;
	}

	if (buf[0] != ',') {
	    /*
	     * Not a valid start character; ignore it.
	     */
	    continue;
	}

	if (fread(buf, 1, 9, f) != 9) {
	    //interp->result = "couldn't read left/top/width/height in GIF image";
	    goto error;
	}

	useGlobalColormap = ! BitSet(buf[8], LOCALCOLORMAP);

	bitPixel = 1<<((buf[8]&0x07)+1);

	if (!useGlobalColormap) {
	    if (!ReadColorMap(f, bitPixel, localColorMap)) {
		    //Tcl_AppendResult(interp, "error reading color map", 
			//    (char *) NULL);
		    goto error;
	    }
	    if (ReadImage(pPixels, f, fileWidth,
		    fileHeight, localColorMap, BitSet(buf[8], INTERLACE),
		    transparent) != TCL_OK) {
		goto error;
	    }
	} else {
	    if (ReadImage(pPixels, f, fileWidth,
		    fileHeight, colorMap, BitSet(buf[8], INTERLACE),
		    transparent) != TCL_OK) {
		goto error;
	    }
	}

    }
    
#ifdef MS_WIN16
/* Reverse image top to bottom */
	{
	size_t count = fileWidth * 3;
	HGLOBAL hTmp = ::GlobalAlloc(GMEM_MOVEABLE, count);
	if (hTmp == 0)
		return FALSE;
	unsigned char * ptTmp = (unsigned char *)::GlobalLock(hTmp);
	unsigned char huge * ptTop = pPixels;
	unsigned char huge * ptBot = pPixels + (long)fileWidth * (fileHeight - 1) * 3;
	while (ptTop < ptBot){
		_fmemmove(ptTmp, ptTop, count);	// _fmemcpy fails on Win 3.1
		_fmemmove(ptTop, ptBot, count);
		_fmemmove(ptBot, ptTmp, count);
		ptTop += count;
		ptBot -= count;
	}
	::GlobalUnlock(hTmp);
	::GlobalFree(hTmp);
	}
#endif

	::GlobalUnlock((HGLOBAL) m_hDIB);
    return TRUE;

    error:
	::GlobalUnlock((HGLOBAL) m_hDIB);
	::GlobalFree((HGLOBAL) m_hDIB);
    return FALSE;

}

/*
 *----------------------------------------------------------------------
 *
 * ReadGIFHeader --
 *
 *	This procedure reads the GIF header from the beginning of a
 *	GIF file and returns the dimensions of the image.
 *
 * Results:
 *	The return value is 1 if file "f" appears to start with
 *	a valid GIF header, 0 otherwise.  If the header is valid,
 *	then *widthPtr and *heightPtr are modified to hold the
 *	dimensions of the image.
 *
 * Side effects:
 *	The access position in f advances.
 *
 *----------------------------------------------------------------------
 */

static int
ReadGIFHeader(FILE *f, int *widthPtr, int *heightPtr)
{
    unsigned char buf[7];

    if ((fread(buf, 1, 6, f) != 6)
	    || ((strncmp("GIF87a", (char *) buf, 6) != 0)
	    && (strncmp("GIF89a", (char *) buf, 6) != 0))) {
	return 0;
    }

    if (fread(buf, 1, 4, f) != 4) {
	return 0;
    }

    *widthPtr = LM_to_uint(buf[0],buf[1]);
    *heightPtr = LM_to_uint(buf[2],buf[3]);
    return 1;
}

/*
 *-----------------------------------------------------------------
 * The code below is copied from the giftoppm program and modified
 * just slightly.
 *-----------------------------------------------------------------
 */

static int
ReadColorMap(FILE *fd, int number, unsigned char buffer[3][MAXCOLORMAPSIZE])
{
	int     i;
	unsigned char   rgb[3];

	for (i = 0; i < number; ++i) {
		if (! ReadOK(fd, rgb, sizeof(rgb)))
			return 0;

		buffer[CM_RED][i] = rgb[0] ;
		buffer[CM_GREEN][i] = rgb[1] ;
		buffer[CM_BLUE][i] = rgb[2] ;
	}
	return 1;
}



static int
DoExtension(FILE *fd, int label, int *transparent)
{
	static unsigned char buf[256];
	int count = 0;

	switch (label) {
		case 0x01:      /* Plain Text Extension */
			break;

		case 0xff:      /* Application Extension */
			break;

		case 0xfe:      /* Comment Extension */
			do {
				count = GetDataBlock(fd, (unsigned char*) buf);
			} while (count > 0);
			return count;

		case 0xf9:      /* Graphic Control Extension */
			count = GetDataBlock(fd, (unsigned char*) buf);
			if (count < 0) {
				return 1;
			}
			if ((buf[0] & 0x1) != 0) {
				*transparent = buf[3];
			}

			do {
			    count = GetDataBlock(fd, (unsigned char*) buf);
			} while (count > 0);
			return count;
	}

	do {
	    count = GetDataBlock(fd, (unsigned char*) buf);
	} while (count > 0);
	return count;
}

static int ZeroDataBlock = 0;

static int
GetDataBlock(FILE *fd, unsigned char *buf)
{
	unsigned char   count;

	if (! ReadOK(fd,&count,1)) {
		return -1;
	}

	ZeroDataBlock = count == 0;

	if ((count != 0) && (! ReadOK(fd, buf, count))) {
		return -1;
	}

	return count;
}


static int
ReadImage(unsigned char HUGE *imagePtr, FILE *fd,
	int len, int height, unsigned char cmap[3][MAXCOLORMAPSIZE],
	int interlace, int transparent)
{
	unsigned char   c;
	long     v;
	long     xpos = 0, ypos = 0, pass = 0;

	/*
	 *  Initialize the Compression routines
	 */
	if (! ReadOK(fd,&c,1))  {
	    //Tcl_AppendResult(interp, "error reading GIF image: ",
		//    Tcl_PosixError(interp), (char *) NULL);
	    return TCL_ERROR;
	}

	if (LWZReadByte(fd, 1, c) < 0) {
	    //interp->result = "format error in GIF image";
	    return TCL_ERROR;
	}

	if (transparent != -1){
		// Assume that Windows always uses white as the background color
		cmap[CM_RED][transparent]   = 0xFF;
		cmap[CM_GREEN][transparent] = 0xFF;
		cmap[CM_BLUE][transparent]  = 0xFF;
	}

	unsigned int ch;
	while ((v = LWZReadByte(fd,0,c)) >= 0 ) {
		ch = imagePtr[ (xpos*3)  +  (ypos *len*3)] = cmap[CM_RED][v];
		ch = imagePtr[ (xpos*3)  +  (ypos *len*3) +1] = cmap[CM_GREEN][v];
		ch = imagePtr[ (xpos*3)  +  (ypos *len*3) +2] = cmap[CM_BLUE][v];

		++xpos;
		if (xpos == len) {
			xpos = 0;
			if (interlace) {
				switch (pass) {
					case 0:
					case 1:
						ypos += 8; break;
					case 2:
						ypos += 4; break;
					case 3:
						ypos += 2; break;
				}

				if (ypos >= height) {
					++pass;
					switch (pass) {
						case 1:
							ypos = 4; break;
						case 2:
							ypos = 2; break;
						case 3:
							ypos = 1; break;
						default:
							return TCL_OK;
					}
				}
			} else {
				++ypos;
			}
		}
		if (ypos >= height)
			break;
	}
	return TCL_OK;
}

static int
LWZReadByte(FILE *fd, int flag, int input_code_size)
{
	static int  fresh = 0;
	int     code, incode;
	static int  code_size, set_code_size;
	static int  max_code, max_code_size;
	static int  firstcode, oldcode;
	static int  clear_code, end_code;
	static int  table[2][(1<< MAX_LWZ_BITS)];
	static int  stack[(1<<(MAX_LWZ_BITS))*2], *sp;
	register int    i;


	if (flag) {

		set_code_size = input_code_size;
		code_size = set_code_size+1;
		clear_code = 1 << set_code_size ;
		end_code = clear_code + 1;
		max_code_size = 2*clear_code;
		max_code = clear_code+2;

		GetCode(fd, 0, 1);

		fresh = 1;

		for (i = 0; i < clear_code; ++i) {
			table[0][i] = 0;
			table[1][i] = i;
		}
		for (; i < (1<<MAX_LWZ_BITS); ++i) {
			table[0][i] = table[1][0] = 0;
		}

		sp = stack;

		return 0;

	} else if (fresh) {

		fresh = 0;
		do {
			firstcode = oldcode = GetCode(fd, code_size, 0);
		} while (firstcode == clear_code);
		return firstcode;
	}

	if (sp > stack)
		return *--sp;

	while ((code = GetCode(fd, code_size, 0)) >= 0) {
		if (code == clear_code) {
			for (i = 0; i < clear_code; ++i) {
				table[0][i] = 0;
				table[1][i] = i;
			}

			for (; i < (1<<MAX_LWZ_BITS); ++i) {
				table[0][i] = table[1][i] = 0;
			}

			code_size = set_code_size+1;
			max_code_size = 2*clear_code;
			max_code = clear_code+2;
			sp = stack;
			firstcode = oldcode = GetCode(fd, code_size, 0);
			return firstcode;

	} else if (code == end_code) {
		int     count;
		unsigned char   buf[260];

		if (ZeroDataBlock)
			return -2;

		while ((count = GetDataBlock(fd, buf)) > 0)
			;

		if (count != 0)
			return -2;
	}

	incode = code;

	if (code >= max_code) {
		*sp++ = firstcode;
		code = oldcode;
	}

	while (code >= clear_code) {
		*sp++ = table[1][code];
		if (code == table[0][code])
			printf("circular table entry BIG ERROR\n");
		code = table[0][code];
	}

	*sp++ = firstcode = table[1][code];

	if ((code = max_code) <(1<<MAX_LWZ_BITS)) {

		table[0][code] = oldcode;
		table[1][code] = firstcode;
		++max_code;
		if ((max_code>=max_code_size) && (max_code_size < (1<<MAX_LWZ_BITS))) {
			max_code_size *= 2;
			++code_size;
		}
	}

	oldcode = incode;

	if (sp > stack)
		return *--sp;
	}
	return code;
}


static int
GetCode(FILE *fd, int code_size, int flag)
{
	static unsigned char    buf[280];
	static int      curbit, lastbit, done, last_byte;
	int         i, j, ret;
	unsigned char       count;

	if (flag) {
		curbit = 0;
		lastbit = 0;
		done = 0;
		return 0;
	}


	if ( (curbit+code_size) >= lastbit) {
		if (done) {
			/* ran off the end of my bits */
			return -1;
		}
		if (last_byte >= 2) {	// last_byte == 0 first time thru
			buf[0] = buf[last_byte-2];
			buf[1] = buf[last_byte-1];
		}

		if ((count = GetDataBlock(fd, &buf[2])) == 0)
			done = 1;

		last_byte = 2 + count;
		curbit = (curbit - lastbit) + 16;
		lastbit = (2+count)*8 ;
	}

	ret = 0;
	for (i = curbit, j = 0; j < code_size; ++i, ++j)
		ret |= ((buf[ i / 8 ] & (1 << (i % 8))) != 0) << j;


	curbit += code_size;

	return ret;
}
/*
 * tkImgFmtPPM.c --
 *
 *	A photo image file handler for PPM (Portable PixMap) files.
 *
 * Copyright (c) 1994 The Australian National University.
 * Copyright (c) 1994-1995 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * [See above for the contents of license.terms]
 *
 * Author: Paul Mackerras (paulus@cs.anu.edu.au),
 *	   Department of Computer Science,
 *	   Australian National University.
 */

static char sccsid2[] = "@(#) tkImgFmtPPM.c 1.7 95/06/14 22:49:55";

/*
 * The maximum amount of memory to allocate for data read from the
 * file.  If we need more than this, we do it in pieces.
 */

#define MAX_MEMORY	10000		/* don't allocate > 10KB */

/*
 * Define PGM and PPM, i.e. gray images and color images.
 */

#define PGM 1
#define PPM 2

static int		FileReadPPM  _ANSI_ARGS_((
			    FILE *f, char *fileName, char *formatString,
			    int destX, int destY,
			    int width, int height, int srcX, int srcY));

/*
 * Prototypes for local procedures defined in this file:
 */

static int		ReadPPMFileHeader _ANSI_ARGS_((FILE *f, int *widthPtr,
			    int *heightPtr));


/*
 *----------------------------------------------------------------------
 *
 * FileReadPPM --
 *
 *	This procedure is called by the photo image type to read
 *	PPM format data from a file and write it into a given
 *	photo image.
 *
 * Results:
 *	A standard TCL completion code.  If TCL_ERROR is returned
 *	then an error message is left in interp->result.
 *
 * Side effects:
 *	The access position in file f is changed, and new data is
 *	added to the image given by imageHandle.
 *
 *----------------------------------------------------------------------
 */

BOOL CWpyImage::ReadImageFilePPM(LPCTSTR fileName)
{
    int fileWidth, fileHeight;
    int type;

	CStdioFile file;
	CFileException fe;

	if (!file.Open(fileName, CFile::modeRead | CFile::typeBinary, &fe))
	{
		return FALSE;
	}

    type = ReadPPMFileHeader(file.m_pStream, &fileWidth, &fileHeight);
    if (type == 0) {
	//Tcl_AppendResult(interp, "couldn't read raw PPM header from file \"",
	//	fileName, "\"", NULL);
	return FALSE;
    }
    if ((fileWidth <= 0) || (fileHeight <= 0)) {
	//Tcl_AppendResult(interp, "PPM image file \"", fileName,
	//	"\" has dimension(s) <= 0", (char *) NULL);
	return FALSE;
    }

	BITMAPINFOHEADER * pDIB;
	unsigned long imageBytes;
    if (type == PGM){	// Gray image
		imageBytes = (long)fileWidth * fileHeight;
		m_numColors = 256;
		// Allocate memory for DIB
		m_hDIB = (HDIB) ::GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT,
			sizeof(BITMAPINFOHEADER) + imageBytes + 256L * sizeof(RGBQUAD));
		if (m_hDIB == 0)
			return FALSE;
		pDIB = (BITMAPINFOHEADER *) ::GlobalLock((HGLOBAL) m_hDIB);
    	pDIB->biBitCount = 8;
		RGBQUAD * rgbq = (RGBQUAD *)pDIB + sizeof(BITMAPINFOHEADER);
		int i;
		for (i = 0; i < 256; i++){
			rgbq[i].rgbRed = i;
			rgbq[i].rgbGreen = i;
			rgbq[i].rgbBlue = i;
			rgbq[i].rgbReserved = 0;
		}	

	}
    else {		// Color image
		imageBytes = (long)fileWidth * fileHeight * 3;
		m_numColors = 0;
		// Allocate memory for DIB
		m_hDIB = (HDIB) ::GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT,
			sizeof(BITMAPINFOHEADER) + imageBytes);
		if (m_hDIB == 0)
			return FALSE;
		pDIB = (BITMAPINFOHEADER *) ::GlobalLock((HGLOBAL) m_hDIB);
    	pDIB->biBitCount = 24;
	}

    m_offsetToBits = sizeof(BITMAPINFOHEADER) + m_numColors * sizeof(RGBQUAD);
    pDIB->biSize = sizeof(BITMAPINFOHEADER);
    pDIB->biWidth = fileWidth;
#ifdef MS_WIN16
    pDIB->biHeight = fileHeight;
#else
    pDIB->biHeight = - fileHeight;	// Automatic invert of image
#endif
    m_sizeDIB = CSize(fileWidth, fileHeight);
    pDIB->biPlanes = 1;
    pDIB->biCompression = BI_RGB;
    pDIB->biSizeImage = 0;
    pDIB->biXPelsPerMeter = 0;
    pDIB->biYPelsPerMeter = 0;
    pDIB->biClrUsed = m_numColors;
    pDIB->biClrImportant = m_numColors;

    unsigned char HUGE * pPixels = (unsigned char HUGE *)pDIB + m_offsetToBits;
	if (file.ReadHuge(pPixels, imageBytes) !=	imageBytes){
		::GlobalUnlock((HGLOBAL) m_hDIB);
		::GlobalFree((HGLOBAL) m_hDIB);
		return FALSE;
	}

	// Rearrange bytes from RGB order to BGR order
	unsigned char HUGE * pt = pPixels;
	unsigned char HUGE * maxPixels = pPixels + imageBytes;
	unsigned char ch;
	while (pt < maxPixels){
		ch = pt[0];
		pt[0] = pt[2];
		pt[2] = ch;
		pt += 3;
	}

#ifdef MS_WIN16
/* Reverse image top to bottom */
	size_t count = fileWidth * 3;
	HGLOBAL hTmp = ::GlobalAlloc(GMEM_MOVEABLE, count);
	if (hTmp == 0)
		return FALSE;
	unsigned char * ptTmp = (unsigned char *)::GlobalLock(hTmp);
	unsigned char huge * ptTop = pPixels;
	unsigned char huge * ptBot = pPixels + (long)fileWidth * (fileHeight - 1) * 3;
	while (ptTop < ptBot){
		_fmemmove(ptTmp, ptTop, count);	// _fmemcpy fails on Win 3.1
		_fmemmove(ptTop, ptBot, count);
		_fmemmove(ptBot, ptTmp, count);
		ptTop += count;
		ptBot -= count;
	}
	::GlobalUnlock(hTmp);
	::GlobalFree(hTmp);
#endif

	::GlobalUnlock((HGLOBAL) m_hDIB);
    return TRUE;
} 
/*
 *----------------------------------------------------------------------
 *
 * ReadPPMFileHeader --
 *
 *	This procedure reads the PPM header from the beginning of a
 *	PPM file and returns the dimensions of the image.
 *
 * Results:
 *	The return value is PGM if file "f" appears to start with
 *	a valid PGM header, PPM if "f" appears to start with a valid
 *      PPM header, and 0 otherwise.  If the header is valid,
 *	then *widthPtr and *heightPtr are modified to hold the
 *	dimensions of the image.
 *
 * Side effects:
 *	The access position in f advances.
 *
 *----------------------------------------------------------------------
 */

static int
ReadPPMFileHeader(FILE *f, int *widthPtr, int *heightPtr)
{
    int maxPixel;
#define BUFFER_SIZE 1000
    char buffer[BUFFER_SIZE];
    int i, numFields, firstInLine, c;
    int type = 0;

    /*
     * Read 4 space-separated fields from the file, ignoring
     * comments (any line that starts with "#").
     */

    c = getc(f);
    firstInLine = 1;
    i = 0;
    for (numFields = 0; numFields < 4; numFields++) {
	/*
	 * Skip comments and white space.
	 */

	while (1) {
	    while (isspace(UCHAR(c))) {
		firstInLine = (c == '\n');
		c = getc(f);
	    }
	    if (c != '#') {
		break;
	    }
	    do {
		c = getc(f);
	    } while ((c != EOF) && (c != '\n'));
	    firstInLine = 1;
	}

	/*
	 * Read a field (everything up to the next white space).
	 */

	while ((c != EOF) && !isspace(UCHAR(c))) {
	    if (i < (BUFFER_SIZE-2)) {
		buffer[i]  = c;
		i++;
	    }
	    c = getc(f);
	}
	buffer[i] = ' ';
	i++;
	firstInLine = 0;
    }
    buffer[i] = 0;

    /*
     * Parse the fields, which are: id, width, height, maxPixel.
     */

    if (strncmp(buffer, "P6 ", 3) == 0) {
	type = PPM;
    } else if (strncmp(buffer, "P5 ", 3) == 0) {
	type = PGM;
    } else {
	return 0;
    }
    if (sscanf(buffer+3, "%d %d %d", widthPtr, heightPtr, &maxPixel) != 3) {
	return 0;
    }
    if (maxPixel != 255) {
	return 0;
    }
    return type;
}
