// window.cpp : implementation file
//

#include "stdafx.h"
#include "app.h"
#include "window.h"
#include "globals.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWpythonWnd

IMPLEMENT_DYNAMIC(CWpythonWnd, CWnd)

CWpythonWnd::CWpythonWnd(PyObject *pyobj)
{
	theApp.RecordObjects(this, pyobj, TRUE);
}

CWpythonWnd::~CWpythonWnd()
{
	theApp.UnRecordCpp(this, TRUE);
}

HWND CWpythonWnd::UnsubclassWindow()
{
	ASSERT(::IsWindow(m_hWnd));

	// set WNDPROC back to original value
	WNDPROC* lplpfn = GetSuperWndProcAddr();
	SetWindowLong(m_hWnd, GWL_WNDPROC, (LONG)*lplpfn);
	*lplpfn = NULL;

	// and Detach the HWND from the CWnd object
	return Detach();
}

#ifdef MS_WIN16
WNDPROC* CWpythonWnd::GetSuperWndProcAddr()
{   
    static WNDPROC pfnSuper;   // place to store window proc
    return &pfnSuper;
}
#endif


BEGIN_MESSAGE_MAP(CWpythonWnd, CWnd)
	//{{AFX_MSG_MAP(CWpythonWnd)
	ON_WM_CHAR()
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWpythonWnd message handlers

void CWpythonWnd::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (WpyOnChar(this, nChar, nRepCnt, nFlags))
		CWnd::OnChar(nChar, nRepCnt, nFlags);
}

void CWpythonWnd::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (WpyOnVChar(this, nChar, nRepCnt, nFlags))
		CWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}
