#include "Python.h"
#include "widgetobject.h"
#include "XColor.h"
#include "Pixmapobject.h"
#include "Xlibmodule.h"

#define PROVIDE_TYPES
#include "event.h"

#include "Xmsupport.h"
#include <Xm/ArrowB.h>
#include <Xm/ArrowBG.h>
#include <Xm/Command.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
#include <Xm/List.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/TextF.h>
#include <X11/Shell.h>
#if XmVersion < 1002
#include <X11/Atom.h>
#define XmFMT_8_BIT	FMT8BIT
#endif /* XmVersion < 1002 */
#if XmVersion >= 1002
#include <Xm/DragDrop.h>
#endif /* XmVersion >= 1002 */

#define TV_LONG		20
#define BOOLEAN		21
#define WIDGET		22
#define XMSTRING	23
#define XMSTRINGLIST	24
#define INTLIST		25
#define CLIENTDATA	26
#define CALLBACKSTRUCT	27
#define TEXTBLOCK	28

#define ANYCALLBACK	10
#define ARROWBUTTON	11
#define DRAWINGAREA	12
#define DRAWNBUTTON	13
#define PUSHBUTTON	14
#define ROWCOLUMN	15
#define SCROLLBAR	16
#define TOGGLEBUTTON	17
#define LIST		18
#define SELECTIONBOX	19
#define COMMAND		20
#define FILESELECTIONBOX 21
#define SCALE		22
#define TRAVERSEOBSCURED 23
#define TEXTVERIFY	24
#define DRAGDROPFINISH	25
#define DRAGMOTION	26
#define DROPFINISH	27
#define DROPSTART	28
#define OPERATIONCHANGED 29
#define TOPLEVELENTER	30
#define TOPLEVELLEAVE	31
#define DRAGPROC	32
#define DROPPROC	33

#ifndef offsetof
#define offsetof(type, member) ( (int) & ((type*)0) -> member )
#endif

#define OFF(t,m)	offsetof(t,m)

static struct callback any[] = {
	{"XmAnyCallbackStruct",},
	{"reason", INT, OFF(XmAnyCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmAnyCallbackStruct, event)},
	{0, 0, 0},
};
static struct callback arrowbutton[] = {
	{"XmArrowButtonCallbackStruct",},
	{"reason", INT, OFF(XmArrowButtonCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmArrowButtonCallbackStruct, event)},
	{"click_count", INT, OFF(XmArrowButtonCallbackStruct, click_count)},
	{0, 0, 0},
};
static struct callback drawingarea[] = {
	{"XmDrawingAreaCallbackStruct",},
	{"reason", INT, OFF(XmDrawingAreaCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmDrawingAreaCallbackStruct, event)},
	{"window", WINDOW, OFF(XmDrawingAreaCallbackStruct, window)},
	{0, 0, 0},
};
static struct callback drawnbutton[] = {
	{"XmDrawnButtonCallbackStruct",},
	{"reason", INT, OFF(XmDrawnButtonCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmDrawnButtonCallbackStruct, event)},
	{"window", WINDOW, OFF(XmDrawnButtonCallbackStruct, window)},
	{"click_count", INT, OFF(XmDrawnButtonCallbackStruct, click_count)},
	{0, 0, 0},
};
#define pushbutton arrowbutton
static struct callback rowcolumn[] = {
	{"XmRowColumnCallbackStruct",},
	{"reason", INT, OFF(XmRowColumnCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmRowColumnCallbackStruct, event)},
	{"widget", WIDGET, OFF(XmRowColumnCallbackStruct, widget)},
	{"data", CLIENTDATA, OFF(XmRowColumnCallbackStruct, data)},
	{"callbackstruct", CALLBACKSTRUCT, OFF(XmRowColumnCallbackStruct, callbackstruct)},
	{0, 0, 0},
};
static struct callback scrollbar[] = {
	{"XmScrollBarCallbackStruct",},
	{"reason", INT, OFF(XmScrollBarCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmScrollBarCallbackStruct, event)},
	{"value", INT, OFF(XmScrollBarCallbackStruct, value)},
	{"pixel", INT, OFF(XmScrollBarCallbackStruct, pixel)},
	{0, 0, 0},
};
static struct callback togglebutton[] = {
	{"XmToggleButtonCallbackStruct",},
	{"reason", INT, OFF(XmToggleButtonCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmToggleButtonCallbackStruct, event)},
	{"set", INT, OFF(XmToggleButtonCallbackStruct, set)},
	{0, 0, 0},
};
static struct callback list[] = {
	{"XmListCallbackStruct",},
	{"reason", INT, OFF(XmListCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmListCallbackStruct, event)},
	{"item", XMSTRING, OFF(XmListCallbackStruct, item)},
	{"item_length", INT, OFF(XmListCallbackStruct, item_length)},
	{"item_position", INT, OFF(XmListCallbackStruct, item_position)},
	{"selected_items", XMSTRINGLIST, OFF(XmListCallbackStruct, selected_items)},
	{"selected_item_count", INT, OFF(XmListCallbackStruct, selected_item_count)},
	{"selected_item_positions", INTLIST, OFF(XmListCallbackStruct, selected_item_positions)},
	{"selection_type", CHAR, OFF(XmListCallbackStruct, selection_type)},
	{0, 0, 0},
};
static struct callback selectionbox[] = {
	{"XmSelectionBoxCallbackStruct",},
	{"reason", INT, OFF(XmSelectionBoxCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmSelectionBoxCallbackStruct, event)},
	{"value", XMSTRING, OFF(XmSelectionBoxCallbackStruct, value)},
	{"length", INT, OFF(XmSelectionBoxCallbackStruct, length)},
	{0, 0, 0},
};
#define command selectionbox
static struct callback fileselectionbox[] = {
	{"XmFileSelectionBoxCallbackStruct",},
	{"reason", INT, OFF(XmFileSelectionBoxCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmFileSelectionBoxCallbackStruct, event)},
	{"value", XMSTRING, OFF(XmFileSelectionBoxCallbackStruct, value)},
	{"length", INT, OFF(XmFileSelectionBoxCallbackStruct, length)},
	{"mask", XMSTRING, OFF(XmFileSelectionBoxCallbackStruct, mask)},
	{"mask_length", INT, OFF(XmFileSelectionBoxCallbackStruct, mask_length)},
	{"dir", XMSTRING, OFF(XmFileSelectionBoxCallbackStruct, dir)},
	{"dir_length", INT, OFF(XmFileSelectionBoxCallbackStruct, dir_length)},
	{"pattern", XMSTRING, OFF(XmFileSelectionBoxCallbackStruct, pattern)},
	{"pattern_length", INT, OFF(XmFileSelectionBoxCallbackStruct, pattern_length)},
	{0, 0, 0},
};
static struct callback scale[] = {
	{"XmScaleCallbackStruct",},
	{"reason", INT, OFF(XmScaleCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmScaleCallbackStruct, event)},
	{"value", INT, OFF(XmScaleCallbackStruct, value)},
	{0, 0, 0},
};
#if XmVersion >= 1002
static struct callback traverseobscured[] = {
	{"XmTraverseObscuredCallbackStruct",},
	{"reason", INT, OFF(XmTraverseObscuredCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmTraverseObscuredCallbackStruct, event)},
	{"traversal_destination", WIDGET, OFF(XmTraverseObscuredCallbackStruct, traversal_destination)},
	{"direction", INT, OFF(XmTraverseObscuredCallbackStruct, direction)},
	{0, 0, 0},
};
#endif /* XmVersion >= 1002 */
static struct callback textverify[] = {
	{"XmTextVerifyCallbackStruct",},
	{"reason", INT, OFF(XmTextVerifyCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmTextVerifyCallbackStruct, event)},
	{"doit", BOOLEAN, OFF(XmTextVerifyCallbackStruct, doit)},
	{"currInsert", LONG, OFF(XmTextVerifyCallbackStruct, currInsert)},
	{"newInsert", LONG, OFF(XmTextVerifyCallbackStruct, newInsert)},
	{"startPos", TV_LONG, OFF(XmTextVerifyCallbackStruct, startPos)},
	{"endPos", TV_LONG, OFF(XmTextVerifyCallbackStruct, endPos)},
	{"text", TEXTBLOCK, OFF(XmTextVerifyCallbackStruct, text)},
	{0, 0, 0},
};
#if XmVersion >= 1002
static struct callback dragdropfinish[] = {
	{"XmDragDropFinishCallbackStruct",},
	{"reason", INT, OFF(XmDragDropFinishCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmDragDropFinishCallbackStruct, event)},
	{"timeStamp", LONG, OFF(XmDragDropFinishCallbackStruct, timeStamp)},
	{0, 0, 0},
};
static struct callback dragmotion[] = {
	{"XmDragMotionCallbackStruct",},
	{"reason", INT, OFF(XmDragMotionCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmDragMotionCallbackStruct, event)},
	{"timeStamp", LONG, OFF(XmDragMotionCallbackStruct, timeStamp)},
	{"operation", UCHAR, OFF(XmDragMotionCallbackStruct, operation)},
	{"operations", UCHAR, OFF(XmDragMotionCallbackStruct, operations)},
	{"dropSiteStatus", UCHAR, OFF(XmDragMotionCallbackStruct, dropSiteStatus)},
	{"x", SHORT, OFF(XmDragMotionCallbackStruct, x)},
	{"y", SHORT, OFF(XmDragMotionCallbackStruct, y)},
	{0, 0, 0},
};
static struct callback dropfinish[] = {
	{"XmDropFinishCallbackStruct",},
	{"reason", INT, OFF(XmDropFinishCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmDropFinishCallbackStruct, event)},
	{"timeStamp", LONG, OFF(XmDropFinishCallbackStruct, timeStamp)},
	{"operation", UCHAR, OFF(XmDropFinishCallbackStruct, operation)},
	{"operations", UCHAR, OFF(XmDropFinishCallbackStruct, operations)},
	{"dropSiteStatus", UCHAR, OFF(XmDropFinishCallbackStruct, dropSiteStatus)},
	{"dropAction", UCHAR, OFF(XmDropFinishCallbackStruct, dropAction)},
	{"completionStatus", UCHAR, OFF(XmDropFinishCallbackStruct, completionStatus)},
	{0, 0, 0},
};
#define dropsiteenter dragmotion
#define dropsiteleave dragdropfinish
static struct callback dropstart[] = {
	{"XmDropStartCallbackStruct",},
	{"reason", INT, OFF(XmDropStartCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmDropStartCallbackStruct, event)},
	{"timeStamp", LONG, OFF(XmDropStartCallbackStruct, timeStamp)},
	{"operation", UCHAR, OFF(XmDropStartCallbackStruct, operation)},
	{"operations", UCHAR, OFF(XmDropStartCallbackStruct, operations)},
	{"dropSiteStatus", UCHAR, OFF(XmDropStartCallbackStruct, dropSiteStatus)},
	{"dropAction", UCHAR, OFF(XmDropStartCallbackStruct, dropAction)},
	{"x", SHORT, OFF(XmDropStartCallbackStruct, x)},
	{"y", SHORT, OFF(XmDropStartCallbackStruct, y)},
	{0, 0, 0},
};
static struct callback operationchanged[] = {
	{"XmOperationChangedCallbackStruct",},
	{"reason", INT, OFF(XmOperationChangedCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmOperationChangedCallbackStruct, event)},
	{"timeStamp", LONG, OFF(XmOperationChangedCallbackStruct, timeStamp)},
	{"operation", UCHAR, OFF(XmOperationChangedCallbackStruct, operation)},
	{"operations", UCHAR, OFF(XmOperationChangedCallbackStruct, operations)},
	{"dropSiteStatus", UCHAR, OFF(XmOperationChangedCallbackStruct, dropSiteStatus)},
	{0, 0, 0},
};
static struct callback toplevelenter[] = {
	{"XmTopLevelEnterCallbackStruct",},
	{"reason", INT, OFF(XmTopLevelEnterCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmTopLevelEnterCallbackStruct, event)},
	{"timeStamp", LONG, OFF(XmTopLevelEnterCallbackStruct, timeStamp)},
	/*{"screen", SCREEN, OFF(XmTopLevelEnterCallbackStruct, screen)},*/
	{"window", WINDOW, OFF(XmTopLevelEnterCallbackStruct, window)},
	{"x", SHORT, OFF(XmTopLevelEnterCallbackStruct, x)},
	{"y", SHORT, OFF(XmTopLevelEnterCallbackStruct, y)},
	{"dragProtocolStyle", UCHAR, OFF(XmTopLevelEnterCallbackStruct, dragProtocolStyle)},
	{0, 0, 0},
};
static struct callback toplevelleave[] = {
	{"XmTopLevelLeaveCallbackStruct",},
	{"reason", INT, OFF(XmTopLevelLeaveCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmTopLevelLeaveCallbackStruct, event)},
	{"timeStamp", LONG, OFF(XmTopLevelLeaveCallbackStruct, timeStamp)},
	/*{"screen", SCREEN, OFF(XmTopLevelLeaveCallbackStruct, screen)},*/
	{"window", WINDOW, OFF(XmTopLevelLeaveCallbackStruct, window)},
	{0, 0, 0},
};
static struct callback dragproc[] = {
	{"XmDragProcCallbackStruct",},
	{"reason", INT, OFF(XmDragProcCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmDragProcCallbackStruct, event)},
	{"timeStamp", LONG, OFF(XmDragProcCallbackStruct, timeStamp)},
	{"dragContext", WIDGET, OFF(XmDragProcCallbackStruct, dragContext)},
	{"x", SHORT, OFF(XmDragProcCallbackStruct, x)},
	{"y", SHORT, OFF(XmDragProcCallbackStruct, y)},
	{"dropSiteStatus", UCHAR, OFF(XmDragProcCallbackStruct, dropSiteStatus)},
	{"operation", UCHAR, OFF(XmDragProcCallbackStruct, operation)},
	{"operations", UCHAR, OFF(XmDragProcCallbackStruct, operations)},
	{"animate", BOOLEAN, OFF(XmDragProcCallbackStruct, animate)},
	{0, 0, 0},
};
static struct callback dropproc[] = {
	{"XmDropProcCallbackStruct",},
	{"reason", INT, OFF(XmDropProcCallbackStruct, reason)},
	{"event", XEVENT, OFF(XmDropProcCallbackStruct, event)},
	{"timeStamp", LONG, OFF(XmDropProcCallbackStruct, timeStamp)},
	{"dragContext", WIDGET, OFF(XmDropProcCallbackStruct, dragContext)},
	{"x", SHORT, OFF(XmDropProcCallbackStruct, x)},
	{"y", SHORT, OFF(XmDropProcCallbackStruct, y)},
	{"dropSiteStatus", UCHAR, OFF(XmDropProcCallbackStruct, dropSiteStatus)},
	{"operation", UCHAR, OFF(XmDropProcCallbackStruct, operation)},
	{"operations", UCHAR, OFF(XmDropProcCallbackStruct, operations)},
	{"dropAction", UCHAR, OFF(XmDropProcCallbackStruct, dropAction)},
	{0, 0, 0},
};
#endif /* XmVersion >= 1002 */


#define GET(bas, off, typ)	(* (typ *) ((char *) (bas) + (off)))
#define SET(bas, off, typ, val)	(* (typ *) ((char *) (bas) + (off)) = (val))

static PyObject *
xmev_get(self, cbp, name)
	X_Callbackobject *self;
	struct callback *cbp;
	char *name;
{
	switch (cbp->type) {
	case BOOLEAN:
		return PyInt_FromLong(
				(long) GET(self->event, cbp->offset, Boolean));
	case WIDGET:
		return (PyObject *) newwidgetobject(
				GET(self->event, cbp->offset, Widget),
				&widget_methodchain, NULL);
	case XMSTRING:
		return xmstring2pstring(
				GET(self->event, cbp->offset, XmString));
	case XMSTRINGLIST:
		{
			int n;
			PyObject *v;
			XmString *p;
			n = GET(self->event, cbp[1].offset, int);
			v = PyList_New(n);
			p = GET(self->event, cbp->offset, XmString *);
			while (--n >= 0)
				PyList_SetItem(v, n, xmstring2pstring(p[n]));
			return v;
		}
	case INTLIST:
		{
			int n;
			PyObject *v;
			int *p;
			n = GET(self->event, cbp[-1].offset, int);
			v = PyList_New(n);
			p = GET(self->event, cbp->offset, int *);
			while (--n >= 0)
				PyList_SetItem(v, n, PyInt_FromLong(p[n]));
			return v;
		}
	case CALLBACKSTRUCT:
	case CLIENTDATA:
		{
			XmRowColumnCallbackStruct *ev;
			PyObject *cbfunc, *cbarg;
			int type;
			ev = (XmRowColumnCallbackStruct *) self->event;
			if (ev->callbackstruct == NULL || ev->data == NULL) {
				Py_INCREF(Py_None);
				return Py_None;
			}
			PyArg_ParseTuple((PyObject *) ev->data, "OOi",
					 &cbfunc, &cbarg, &type);
			if (cbp->type == CLIENTDATA) {
				Py_INCREF(cbarg);
				return cbarg;
			}
			return xev_ev(self, ev->callbackstruct, type);
		}
	case TEXTBLOCK:
		{
			XmTextBlock b;
			PyObject *v;
			if (((XmTextVerifyCallbackStruct *) self->event)->reason != XmCR_MODIFYING_TEXT_VALUE) {
				PyErr_SetString(PyExc_AttributeError, name);
				return NULL;
			}
			b = GET(self->event, cbp->offset, XmTextBlock);
			if (b->ptr == NULL) {
				Py_INCREF(Py_None);
				return Py_None;
			}
			return PyString_FromStringAndSize(b->ptr, b->length);
		}
	case TV_LONG:
		/* special case for XmTextVerifyCallbackStruct :-( */
		if (((XmTextVerifyCallbackStruct *) self->event)->reason ==
						XmCR_MOVING_INSERT_CURSOR) {
			PyErr_SetString(PyExc_AttributeError, name);
			return NULL;
		}
		return PyInt_FromLong(GET(self->event, cbp->offset, long));
	default:
		return NULL;
	}
}

static int
xmev_set(self, cbp, name, value)
	X_Callbackobject *self;
	struct callback *cbp;
	char *name;
	PyObject *value;
{
	switch (cbp->type) {
	case BOOLEAN:
		{
			Boolean v = PyInt_AsLong(value);
			if (PyErr_Occurred())
				return -1;
			SET(self->event, cbp->offset, Boolean, v);
			return 0;
		}
	case TV_LONG:
		/* special case for XmTextVerifyCallbackStruct :-( */
		if (((XmTextVerifyCallbackStruct *) self->event)->reason ==
						XmCR_MOVING_INSERT_CURSOR) {
			PyErr_SetString(PyExc_AttributeError, name);
			return -1;
		}
		{
			long v = PyInt_AsLong(value);
			if (PyErr_Occurred())
				return -1;
			SET(self->event, cbp->offset, long, v);
			return 0;
		}
	case TEXTBLOCK:
		{
/* We have to choose between a memory leak and confusion.  The
   confusion occurs when TextVerify callbacks are called recursively,
   the text is changed in both callbacks, and the text in the outer
   callback is changed before the inner one is called.  We have chosen
   for the confusion, since it will occur extremely rarely.  The
   memory leak can be chosen by reversing the #if conditions. */
			XmTextBlock b;
#if !0
			static XmTextBlockRec br;
			b = &br;
#endif
			if (((XmTextVerifyCallbackStruct *) self->event)->reason != XmCR_MODIFYING_TEXT_VALUE) {
				PyErr_SetString(PyExc_AttributeError, name);
				return -1;
			}
#if 0
			b = PyMem_NEW(XmTextBlockRec, 1);
#endif
			b->ptr = PyString_AsString(value);
			if (PyErr_Occurred()) {
#if 0
				PyMem_DEL(b);
#endif
				return -1;
			}
			b->length = PyString_Size(value);
			b->format = XmFMT_8_BIT;
			SET(self->event, cbp->offset, XmTextBlock, b);
			return 0;
		}
	default:
		return 1;
	}
}

static int
xmev_gettype(w, callback_name)
	Widget w;
	char *callback_name;
{
	WidgetClass wc;

#if XmVersion >= 1002
	if (callback_name != NULL) {
		if (strcmp(callback_name, XmNdragProc) == 0)
			return DRAGPROC;
		if (strcmp(callback_name, XmNdropProc) == 0)
			return DROPPROC;
	}
#endif /* XmVersion >= 1002 */

	wc = XtClass(w);

	if (wc == xmArrowButtonWidgetClass || wc == xmArrowButtonGadgetClass)
		return ARROWBUTTON;
	if (wc == xmCommandWidgetClass)
		return COMMAND;
	if (wc == xmDrawingAreaWidgetClass)
		return DRAWINGAREA;
	if (wc == xmDrawnButtonWidgetClass)
		return DRAWNBUTTON;
	if (wc == xmFileSelectionBoxWidgetClass)
		return FILESELECTIONBOX;
	if (wc == xmListWidgetClass)
		return LIST;
	if (wc == xmPushButtonWidgetClass || wc == xmPushButtonGadgetClass)
		return PUSHBUTTON;
	if (wc == xmRowColumnWidgetClass)
		return ROWCOLUMN;
	if (wc == xmScaleWidgetClass)
		return SCALE;
	if (wc == xmScrollBarWidgetClass)
		return SCROLLBAR;
#if XmVersion >= 1002
	if (wc == xmScrolledWindowWidgetClass)
		return TRAVERSEOBSCURED;
#endif /* XmVersion >= 1002 */
	if (wc == xmSelectionBoxWidgetClass)
		return SELECTIONBOX;
	if (wc == xmTextWidgetClass || wc == xmTextFieldWidgetClass) {
		if (callback_name == NULL)
			return ANYCALLBACK;
		if (strcmp(callback_name, XmNlosingFocusCallback) == 0 ||
		    strcmp(callback_name, XmNmodifyVerifyCallback) == 0 ||
		    strcmp(callback_name, XmNmotionVerifyCallback) == 0)
			return TEXTVERIFY;
	}
	if (wc == xmToggleButtonWidgetClass || wc == xmToggleButtonGadgetClass)
		return TOGGLEBUTTON;
#if XmVersion >= 1002
	if (wc == xmDragContextClass) {
		if (strcmp(callback_name, XmNdragDropFinishCallback) == 0)
			return DRAGDROPFINISH;
		if (strcmp(callback_name, XmNdragMotionCallback) == 0 ||
		    strcmp(callback_name, XmNdropSiteEnterCallback) == 0)
			return DRAGMOTION;
		if (strcmp(callback_name, XmNdropFinishCallback) == 0 ||
		    strcmp(callback_name, XmNdropSiteLeaveCallback) == 0)
			return DROPFINISH;
		if (strcmp(callback_name, XmNdropStartCallback) == 0)
			return DROPSTART;
		if (strcmp(callback_name, XmNoperationChangedCallback) == 0)
			return OPERATIONCHANGED;
		if (strcmp(callback_name, XmNtopLevelEnterCallback) == 0)
			return TOPLEVELENTER;
		if (strcmp(callback_name, XmNtopLevelLeaveCallback) == 0)
			return TOPLEVELLEAVE;
	}
#endif /* XmVersion >= 1002 */
	if (XtIsSubclass(w, xmPrimitiveWidgetClass) ||
	    XtIsSubclass(w, vendorShellWidgetClass))
		return ANYCALLBACK;
	return -1;
}

static struct callback *
xmev_getcb(ptr, type)
	XtPointer ptr;
	int type;
{
	switch (type) {
	case ARROWBUTTON:
		return arrowbutton;
	case DRAWINGAREA:
		return drawingarea;
	case DRAWNBUTTON:
		return drawnbutton;
	case PUSHBUTTON:
		return pushbutton;
	case ROWCOLUMN:
		return rowcolumn;
	case SCROLLBAR:
		return scrollbar;
	case TOGGLEBUTTON:
		return togglebutton;
	case LIST:
		return list;
	case SELECTIONBOX:
		return selectionbox;
	case COMMAND:
		return command;
	case FILESELECTIONBOX:
		return fileselectionbox;
	case SCALE:
		return scale;
#if XmVersion >= 1002
	case TRAVERSEOBSCURED:
		return traverseobscured;
	case DRAGDROPFINISH:
		return dragdropfinish;
	case DRAGMOTION:
		return dragmotion;
	case DROPFINISH:
		return dropfinish;
	case DROPSTART:
		return dropstart;
	case OPERATIONCHANGED:
		return operationchanged;
	case TOPLEVELENTER:
		return toplevelenter;
	case TOPLEVELLEAVE:
		return toplevelleave;
	case DRAGPROC:
		return dragproc;
	case DROPPROC:
		return dropproc;
#endif /* XmVersion >= 1002 */
	case TEXTVERIFY:
		return textverify;
	case ANYCALLBACK:
		return any;
	default:
		return NULL;
	}
}

void
xmev_init()
{
	xev_addfuncs(xmev_get, xmev_set, xmev_gettype, xmev_getcb);
}
