import regex, string

# xm = regex.compile('Xm\\(\\.[A-Za-z][A-Za-z]*[ \t]*([ \t]*\\)')
relist = ['Xm\\(\\.[A-Za-z][A-Za-z]*[ \t]*([ \t]*\\)',
	  'Xlib\\(\\.CheckMaskEvent[ \t]*([ \t]*\\)',
	  'Xlib\\(\\.PutBackEvent[ \t]*([ \t]*\\)',
	  'Xlib\\(\\.CreateFontCursor[ \t]*([ \t]*\\)',
	  'Xlib\\(\\.NextEvent[ \t]*([ \t]*\\)',
	  'Xlib\\(\\.PeekEvent[ \t]*([ \t]*\\)',
	  'Xlib\\(\\.Flush[ \t]*([ \t]*\\)',
	  'Xlib\\(\\.ConnectionNumber[ \t]*([ \t]*\\)',
	  'HTML\\(\\.AnchorPosition[ \t]*([ \t]*\\)',
	  'HTML\\(\\.ClearSelection[ \t]*([ \t]*\\)',
	  'HTML\\(\\.GetHRefs[ \t]*([ \t]*\\)',
	  'HTML\\(\\.GetText[ \t]*([ \t]*\\)',
	  'HTML\\(\\.GetTextAndSelection[ \t]*([ \t]*\\)',
	  'HTML\\(\\.IdToPosition[ \t]*([ \t]*\\)',
	  'HTML\\(\\.PositionToId[ \t]*([ \t]*\\)',
	  'HTML\\(\\.SearchText[ \t]*([ \t]*\\)',
	  'HTML\\(\\.SetSelection[ \t]*([ \t]*\\)',
	  'HTML\\(\\.SetText[ \t]*([ \t]*\\)'
	 ]
regexps = []
for re in relist:
	regexps.append(regex.compile(re))
xc_re = regex.compile('Xcursorfont\\.XC_')

def convert(infile, outfile):
	while 1:
		line = infile.readline()
		if not line:
			break
		changed = 1
		while changed:
			changed = 0
			for re in regexps:
				matchstart = re.search(line)
				if matchstart >= 0:
					line = do_convert(infile, line, re,
							  matchstart)
					changed = 1
					break
			matchstart = xc_re.search(line)
			if matchstart >= 0:
				changed = 1
				line = line[:matchstart] + 'Xcursorfont.' + \
				       line[matchstart+len(xc_re.group(0)):]
		outfile.write(line)

def do_convert(infile, line, re, matchstart):
	newline = line[:matchstart]
	matchlen = len(re.group(0))
	depth = 0
	i = matchstart + matchlen
	end = i
	while 1:
		if i == len(line):
			line = line + infile.readline()
		if i == len(line):
			# at end of file
			break
		c = line[i]
		if c == '(':
			depth = depth + 1
		elif c == ')':
			if depth == 0:
				break
			depth = depth - 1
		elif c == ',' and depth == 0:
			break
		if c not in string.whitespace:
			end = i
		i = i + 1
	newline = newline + line[matchstart + matchlen:end+1] + \
		  re.group(1)
	if c == ',':
		while 1:
			i = i + 1
			if i == len(line):
				break
			if line[i] not in string.whitespace or line[i] == '\n':
				break
	newline = newline + line[i:]
	return newline

##def main():
##	import sys
##	if len(sys.argv) > 3:
##		print 'Usage:',sys.argv[0],'[ infile [ outfile ] ]'
##		sys.exit(1)
##	infile = sys.stdin
##	outfile = sys.stdout
##	if len(sys.argv) > 1:
##		infile = open(sys.argv[1], 'r')
##		if len(sys.argv) > 2:
##			outfile = open(sys.argv[2], 'w')
##	convert(infile, outfile)

def do_it(tmp, top, names):
	import posixpath
	print 'Trying directory', top
	for file in names:
		if file[-3:] == '.py':
			file = posixpath.join(top, file)
			try:
				infile = open(file, 'r')
			except:
				print 'Warning: cannot open',file
				continue
			outfile = open(tmp, 'w')
			convert(infile, outfile)
			infile.seek(0)
			indata = infile.read()
			infile.close()
			outfile.close()
			outfile = open(tmp, 'r')
			outdata = outfile.read()
			outfile.close()
			if indata != outdata:
				print 'Updating',file
				# make backup copy
				try:
					outfile = open(file + '~', 'w')
				except:
					print 'Warning: cannot make backup copy for', file
				else:
					outfile.write(indata)
					outfile.close()
				# overwrite original
				try:
					outfile = open(file, 'w')
				except:
					print 'Warning: cannot write', file
				else:
					outfile.write(outdata)
					outfile.close()

def main():
	import tempfile, posixpath, sys
	tmp = tempfile.mktemp()
	if len(sys.argv) <= 1:
		sys.argv = ['', '.']
	for dir in sys.argv[1:]:
		posixpath.walk(dir, do_it, tmp)


import sys
if __name__ == '__main__' or sys.argv[0] == __name__:
	main()
