/* Widget Set Glx */

#include "Python.h"
#include "modsupport.h"
#include "import.h"
#include "widgetobject.h"

#define is_optwidgetobject(x)	((x) == Py_None || is_widgetobject(x))
#define getoptwidgetvalue(x)	((x) == Py_None ? NULL : getwidgetvalue(x))

#include "Glxsupport.h"

/* Methods for Glx objects */

#include <X11/Xirisw/GlxDraw.h>

static PyMethodDef Glx_methods[] = {
	{"makeconfig", (PyCFunction)Glx_makeconfig, 1},
	{"winset", (PyCFunction)Glx_winset, 1},
	{0, 0} /* Sentinel */
};


/* Methods for Glxwc objects */

static PyMethodDef Glxwc_methods[] = {
	{0, 0} /* Sentinel */
};


/* Methods for Glxw objects */

static PyMethodDef Glxw_methods[] = {
	{0, 0} /* Sentinel */
};


PyMethodChain Glxw_methodchain = {
	Glxw_methods,
	NULL,
};
PyMethodChain Glxwc_methodchain = {
	Glxwc_methods,
	&wclass_methodchain,
};

void
initGlx()
{
	PyObject *m, *d;
	m = PyImport_ImportModule("Xt");
	if (m == NULL)
		Py_FatalError("can't import module Xt for Glx");
	Py_DECREF(m);
	m = Py_InitModule("Glx", Glx_methods);
	d = PyModule_GetDict(m);
	add_widget_methodchain(&Glxw_methodchain);
	PyDict_SetItemString(d, "Draw",
		(PyObject*)newwclassobject(glxDrawWidgetClass,
			&Glxwc_methodchain));
	initglxsupport();
}
