# -------------------------------------------------------------------------
# DESCRIPTION: 
#     The menu example from D. Young's Xt/Motif book. Demonstrates how
#     pulldown menu's can be made.
#
# USAGE: 
#     > python menu3.py
#

import sys, os, Xt, Xm
import X, Xmd          # constants for Xt & Xm

# -------------------------------------------------------------------------
# Main function:

def main():
	# Initialize and create a bulletinboard widget as the primary widget

	toplevel = Xt.Initialize('MenuTest', [], sys.argv )
	toplevel.SetValues( {'width': 200, 'height': 200} )
	bboard   = toplevel.CreateManagedWidget('bboard', Xm.BulletinBoard, {})

	# Create and manage a menubar

	menubar = bboard.CreateMenuBar('menubar', {})
	menubar.ManageChild()

	# Create two pulldown menus

	CreatePDMenuOne( menubar )
	CreatePDMenuTwo( menubar )

	toplevel.RealizeWidget()
	Xt.MainLoop()


def CreatePDMenuOne( menubar ):	
	# A pulldown menu is activated by a cascade button in the menubar.
	# Both the pulldown menu and the cascade button must be children of 
	# the menubar. 

	pdbutton = menubar.CreateManagedWidget('Menu1', Xm.CascadeButton, {})
	menu     = menubar.CreatePulldownMenu('menu one', {}) 

	# Connect "menu" to "pdbutton"

	pdbutton.subMenuId = menu

	# Add buttons and callbacks to "menu"

	button1 = menu.CreateManagedWidget( 'm1: Item1', Xm.PushButton, {} )
	button2 = menu.CreateManagedWidget( 'm1: Item2', Xm.PushButton, {} )
	button3 = menu.CreateManagedWidget( 'm1: Item3', Xm.PushButton, {} )

	button1.AddCallback( 'activateCallback', DoItCB, 'm1: Item1' )
	button2.AddCallback( 'activateCallback', DoItCB, 'm1: Item2' )
	button3.AddCallback( 'activateCallback', DoItCB, 'm1: Item3' )

def CreatePDMenuTwo( menubar ):	
	pdbutton = menubar.CreateManagedWidget('Menu2', Xm.CascadeButton, {})
	menu     = menubar.CreatePulldownMenu('menu two', {}) 
	pdbutton.subMenuId = menu

	button1 = menu.CreateManagedWidget( 'm2: Item1', Xm.PushButton, {} )
	button2 = menu.CreateManagedWidget( 'm2: Item2', Xm.PushButton, {} )
	button3 = menu.CreateManagedWidget( 'm2: Item3', Xm.PushButton, {} )

	button1.AddCallback( 'activateCallback', DoItCB, 'm2: Item1' )
	button2.AddCallback( 'activateCallback', DoItCB, 'm2: Item2' )
	button3.AddCallback( 'activateCallback', DoItCB, 'm2: Item3' )


# -------------------------------------------------------------------------
# Callback functions:

def DoItCB( w, client_data, call_data ):
	print client_data, 'called'



main()
