# -------------------------------------------------------------------------
# DESCRIPTION: 
#     The memo example from D. Young's Xt/Motif book. 
#
#     This version uses XmPushButton widget instead of the XmLabel widget, 
#     and uses a callback function instead of an event handler.
#
# USAGE: 
#     > python memo_cb.py <message to be displayed>
#

import sys, os, string, Xt, Xm

def CreateArgvString( argv ):
	if len(argv) > 1:
		s = string.join( argv[1:len(argv)] )
	else:
		s = 'No args'
	return s

# -------------------------------------------------------------------------
# main function
	
def main():
	# Initialize & create a push-button widget to hold the string

	toplevel = Xt.Initialize('Memo', [], sys.argv )
	msg_widget = toplevel.CreateManagedWidget('msg', Xm.PushButton, {})

	# Create the string to be displayed

	message = CreateArgvString( sys.argv )
	msg_widget.labelString = message

	# Add a callback

	msg_widget.AddCallback( 'activateCallback', quitCB, 0 )

	# Realize the widgets and enter the main loop

	toplevel.RealizeWidget()
	Xt.MainLoop()

# -------------------------------------------------------------------------
# Callback function:
#
# Some widgets support callback functions. Callbacks are different than 
# event handlers because they are invoked by the widget rather than the 
# Xt intrinisics, and are not necessarily tied to any particular event. 
#
# Another difference is the 3'rd argument, which in the case of an event
# handler function is simply an XEvent structure, while in the case of a
# callback function this is a more complex structure (a union) which at
# the minimum contains the following fields:
#
# typedef struct {
#     int     reason;
#     XEvent *event;
# } XmAnyCallbackStruct;
#
	 
def quitCB(w, client_data, call_data):
	print 'quitCB called'
	# Xt.CloseDisplay(Xt.Display(w)) # not supported yet
	sys.exit(0)


main()
