# -------------------------------------------------------------------------
# DESCRIPTION: 
#     The formtest example from D. Young's Xt/Motif book. 
#
#     Demonstrates the use of the constraints of the XmForm widget. 
#
# USAGE: 
#     > python formtest.py
#

import sys, os, Xt, Xm
import Xmd     # constants for Xm

buttons = ['button1', 'button2', 'button3', 'button4',\
           'button5', 'button6', 'button7', 'button8']

# -------------------------------------------------------------------------
# Main function:

def main():		
	# Initialize

	void = os.system('xrdb -nocpp -merge Formtest.resources')
	toplevel = Xt.Initialize('Formtest', [], sys.argv )

	# Create the form widget

	form = toplevel.CreateManagedWidget('form', Xm.Form, {})

	# Create 3 children of the form widget

	button = []
	for i in range(3):
		button.append( form.CreateManagedWidget(buttons[i], Xm.PushButton,{}))

	# The name "ManageChildren" is a misleading name, because what
	# this realy means is that the *child* should tell its parent
	# that it should be managed, e.g:
	#     button.ManageChild()
	# means "button should tell its parent that it should be
	# managed". The intuitive form:
	#     form.ManageChildren()
	# will thus *not* cause the "form" to manage its children!!

	Xt.ManageChildren(button)


	# Set the constraint resources for each button, setting up a shape 
	# like this:
	#        button1
	#        button2
	#        button3

	wargs = {'topAttachment': Xmd.ATTACH_FORM,
		 'leftAttachment': Xmd.ATTACH_FORM,
		 'rightAttachment': Xmd.ATTACH_FORM}
	button[0].SetValues( wargs )

	wargs = {'topAttachment': Xmd.ATTACH_WIDGET,
		 'topWidget': button[0],
	         'leftAttachment': Xmd.ATTACH_FORM,
		 'rightAttachment': Xmd.ATTACH_FORM}
	button[1].SetValues( wargs )

	wargs = {'topAttachment': Xmd.ATTACH_WIDGET,
		 'topWidget': button[1],
		 'leftAttachment': Xmd.ATTACH_FORM,
		 'rightAttachment': Xmd.ATTACH_FORM,
		 'bottomAttachment': Xmd.ATTACH_FORM}
	button[2].SetValues( wargs )

	# Realize the widget and enter the main loop

	toplevel.RealizeWidget()
	Xt.MainLoop()

main()
