# -------------------------------------------------------------------------
# DESCRIPTION: 
#     The formedit example from D. Young's Xt/Motif book.
#
#     Demonstrates use of the XmBulletinBoard-, XmText-, and XmPushButton
#     widget. Also shows how to use resources (in the file Formedit.resources).
#
# USAGE: 
#     > python formedit.py 
#

import sys, os, Xt, Xm

buttons = ['button1', 'button2', 'button3']
editors = ['field1', 'field2', 'field3']

# -------------------------------------------------------------------------
# Main function:

def main():	
	# Load resources from the file "Formedit.resources"

	void = os.system('xrdb -nocpp -merge Formedit.resources')

	# Initialize

	toplevel = Xt.Initialize('Formedit', [], sys.argv )

	# Create the bulletin board widget that manages the edit fields

	bb = toplevel.CreateManagedWidget('board', Xm.BulletinBoard, {})

	# Create 3 single-line text widgets and associate a button with each
	# text widget. Assign an 'activateCallback' to each button.

	edit = []
	for e in editors:
		edit.append( bb.CreateManagedWidget( e, Xm.Text, {} ) )

	button = []
	for i in range(3):
		button.append( bb.CreateManagedWidget( buttons[i], Xm.PushButton, {} ))
		button[i].AddCallback( 'activateCallback', GetTextCB, edit[i] )
	
	# Realize the widget and enter the main loop

	toplevel.RealizeWidget()
	Xt.MainLoop()

# -------------------------------------------------------------------------
# Callback function:

def GetTextCB( w, textwidget, call_data ):
	str = textwidget.TextGetString()
	print str



main()
