# -------------------------------------------------------------------------
# MODULE:      Xu
#
# DESCRIPTION: 
#     A module with some X utilities including some taken from D. Young's
#     Xt/Motif book.
#
# USAGE: 
#     > import Xu
#

import Xt, Xm

# -------------------------------------------------------------------------
# FUNCTION: ListValues
#
# DESCRIPTION: 
#     Prints all resources names, class-names, and their default values.
#
# RETURN VALUE: 
#     None
#

def ListValues(w):
	c = w.Class()
	list = c.GetResourceList()
	list.sort()
	dict = {}
	names = []
	for item in list:
		names.append(item[0])
		dict[item[0]] = item

	pairs = w.GetValues(names)
	for name, value in pairs:
		cls = dict[name][1]
		type = dict[name][2]
		print '%-19s %-19s %-19s %s' % (name, cls, type, `value`)

# -------------------------------------------------------------------------
# FUNCTION: CreateMenu
#
# DESCRIPTION: 
#     Creates a menu widget from the items in the "menu_list" and makes it
#     a child of the "parent" widget.
#
# USAGE:
#     "CreateMenu" expects a list containing tuples. The tuple can have the
#     following values:
#     - ( <label>, None )          : a label item (title)
#     - ( <label>, <CB function> ) : a normal item
#     - ( <label>, <list> )        : submenu (cascading menu)
#
#     Example:
#     ----------------------------------------------------------------------
#     import Xt, Xm, Xu
#     
#     ...
#     bboard   = toplevel.CreateManagedWidget('bboard', Xm.BulletinBoard, {})
#
#     # Create a cascading popup menu
#
#     submenu  = [ ('aSubMenu', None), \
#                  ('itemA', DoItCB), ('itemB', DoItCB), ('itemC', DoItCB) ]
#     mainmenu = [ ('aMenu', None), \
#                  ('item1', DoItCB), ('item2', submenu), ('item3', DoItCB) ] 
#
#     menu = Xu.CreateMenu( bboard, mainmenu )
#
#     # Add an event handler to the bulletinboard widget 
#     # to pop up the menu when a mouse is pressed.
#
#     bboard.AddEventHandler(X.ButtonPressMask, X.FALSE, DisplayMenuEH, menu)
#     ----------------------------------------------------------------------
#
# RETURN VALUE: 
#     Menu widget.
#

def _xyz(): # used for type checking in "_CreateMenuItems"
	pass

def CreateMenu( parent, menu_list ):
	menu = parent.CreatePopupMenu( 'Menu', {} )
	_CreateMenuItems( menu, menu_list )
	return menu

def _CreateMenuItems( menu, menu_list ):
	fp   = _xyz

	for i in range(len(menu_list)):
		(label, cb) = menu_list[i]
		if cb == None:             # label item

			void = menu.CreateManagedWidget( label, Xm.Label, {} )
			void = menu.CreateManagedWidget( 'separator', Xm.Separator, {} )

		elif type(cb) == type(fp): # normal menu item

			item = menu.CreateManagedWidget( label, Xm.PushButton, {} )
			item.AddCallback( 'activateCallback', cb, label )

		else:                      # make a cascading submenu
	
			submenu = menu.CreatePulldownMenu( 'SubMenu', {} )
			item = menu.CreateManagedWidget( label, Xm.CascadeButton, {} )
			item.subMenuId = submenu
	
			_CreateMenuItems( submenu, cb )


# -------------------------------------------------------------------------
# FUNCTION: CreateMenuBar
#
# DESCRIPTION: 
#     Similar to "CreateMenu" except that it will create a menubar widget.
#
# RETURN VALUE: 
#     Returns a menubar widget.
#

def CreateMenuBar( parent, menu_list ):
	menubar = parent.CreateMenuBar( 'MenuBar', {} )
	_CreateMenuItems( menubar, menu_list )
	menubar.ManageChild()
	return menubar

	
		
