import sys
import HTML
import Xt
import Xm
import Xmd
import X

def cb_anchor(widget, userdata, calldata):
	print 'anchor callback:', widget, userdata
	event = calldata.event
	print 'event =', calldata.event
	print 'elid =', calldata.element_id
	print 'text =', `calldata.text`
	print 'href =', `calldata.href`
	print 'pos =', widget.IdToPosition(calldata.element_id)

image_cache = {}
def resolveImage(widget, edata, noload = 0):
	print 'resolveImage',edata
	try:
		return image_cache[edata]
	except KeyError:
		pass
	if noload:
		return
	try:
		import img, imgformat
	except ImportError:
		return
	try:
		reader = img.reader(imgformat.xcolormap, edata)
	except:
		return
	colors = []
	for i in range(len(reader.colormap)):
		colors.append(reader.colormap[i])
	dict = {'width': reader.width, 'height': reader.height,
		'image_data': reader.read(), 'colors': colors}
	image_cache[edata] = dict
	return dict

def main():
	top = Xt.Initialize()

	file = 'test.html'
	if sys.argv[1:]:
		file = sys.argv[1]
	try:
		fp = open(file, 'r')
	except IOError, msg:
		print 'Can\'t open', file, ':', msg
		sys.exit(1)
	text = fp.read()
	fp.close()

	h = top.CreateManagedWidget('h', HTML.html,
				    {'resolveImageFunction': resolveImage,
				     'resolveDelayedImage': resolveImage})

	top.RealizeWidget()

	h.AddCallback('anchorCallback', cb_anchor, None)
	h.SetText(text, None, None)

	Xt.MainLoop()

main()
