# Python WWW browser (built out of existing components mostly)

import os
import sys
import string
import urllib
import HTML
import Xt
import Xm
import Xmd

def urlget(newurl):
	return urllib.urlopen(newurl).read()

def cb_form(widget, userdata, calldata):
	print 'FORM'
	href, method, enctype = calldata.href, calldata.method, calldata.enctype
	print 'href=', href
	print 'method=', method
	print 'enctype=', enctype
	print 'enc_entity=', calldata.enc_entity
	print 'attribute_names=', calldata.attribute_names
	print 'attribute_values=', calldata.attribute_values
	list = map(lambda a,b: (a,b),
		   calldata.attribute_names, calldata.attribute_values)
	print 'list=', list
	if enctype <> None:
		print "Don't understand enctype=", enctype
		return
	if method not in (None, 'GET'):
		print "Don't understand method=", method
		return
	if not list:
		print 'Huh? No attributes!'
		return
	if href:
		newurl = urllib.basejoin(url, href)
	else:
		newurl = url
	if len(list) == 1 and list[0][0] == 'isindex':
		newurl = newurl + '?' + list[0][1]
	else:
		newurl = newurl + '?'
		for i in range(len(list)):
			list[i] = list[i][0] + '=' + list[i][1]
		newurl = newurl + string.joinfields(list, '&')
	gotourl(widget, newurl)

def cb_anchor(widget, userdata, calldata):
	global url, text
	print 'ANCHOR'
	print 'text=', calldata.text
	print 'href=', calldata.href
	text = calldata.text
	newurl = urllib.basejoin(url, calldata.href)
 	gotourl(widget, newurl)

def cb_link(widget, userdata, calldata):
	global url
	href = calldata.href
	print 'LINK'
	print 'href=', href
	print 'role=', calldata.role
	if href:
		url = href

image_cache = {}
def cb_image(widget, src, noload = 0):
	global url
	src = urllib.basejoin(url, src)
	try:
		return image_cache[src]
	except KeyError:
		pass
	try:
		src, info = urllib.urlretrieve(src)
	except IOError, msg:
		print 'urlretrieve',src,'failed',`msg`
		return
	import img, imgformat
	try:
		reader = img.reader(imgformat.xcolormap, src)
	except:
		print 'reading',src,'failed'
		return
	colors = map(lambda x: x, reader.colormap)
	if hasattr(reader, 'transparent'):
		colors[reader.transparent] = widget.DefaultColormapOfScreen().QueryColor(widget.background)[1:4]
	dict = {'width': reader.width, 'height': reader.height,
		'image_data': reader.read(), 'colors': colors}
	image_cache[src] = dict
	return dict

def gotourl(widget, newurl):
	global url, text
	newurl, tag = urllib.splittag(newurl)
	print 'Following link to', `newurl`
	try:
		newtext = urlget(newurl)
		print 'Got it'
	except IOError:
		print 'Exception:', sys.exc_type, sys.exc_value
		return
	url = newurl
	widget.headerText = '<P>URL: ' + newurl + '<P>'
	widget.text = newtext
	widget.footerText = footerText
	text = newtext

def main():
	global url, text, footerText
	top = Xt.Initialize()

	if sys.argv[1:]:
		url = sys.argv[1]
	else:
		url = os.environ['WWW_HOME']

	footerText = '<P><A HREF="%s">back to start page</A>' % url

	h = top.CreateManagedWidget('h', HTML.html,
				    {'resolveImageFunction': cb_image})
	h.AddCallback('anchorCallback', cb_anchor, None)
	h.AddCallback('submitFormCallback', cb_form, None)
	h.AddCallback('linkCallback', cb_link, None)

	gotourl(h, url)

	top.RealizeWidget()

	Xt.MainLoop()

main()
