# Real-time clock.

import time

class RTClock:

	def __init__(self):
		self.epoch = None

	# Return the clock speed.  If a clock runs faster/slower than
	# real time, this is larger/smaller than 1.
	def clock_speed(self):
		if self.epoch is None:
			return None
		else:
			return 1.0

	# Check whether the timer is running
	def is_running(self):
		return self.epoch is not None

	# Start the timer, given an initial nominal time.
	def start_timer(self, now):
		self.epoch = time.time() - now

	# Return the current (nominal) time.
	def current_time(self):
		if self.epoch is None:
			return None
		else:
			return time.time() - self.epoch

	# Stop the timer, return the final nominal time.
	def stop_timer(self):
		if self.epoch is None: return None
		now = time.time() - self.epoch
		self.epoch = None
		return now

def test():
	import time
	t = RTClock()
	t.start_timer(30)
	while t.current_time() < 40:
		print t.current_time()
		time.sleep(0.5)
