import Xt
import Xm
import Glx
import GLX
import sys
sys.path.append('/ufs/guido/src/video')
import VFile

class GlxVideoSink:

	def __init__(self, parent, args):
		self.rgbmode = 0
		self.expose_hook = None
		self.displayer = VFile.Displayer()
		self.displayer.set_rgbmode = self.set_rgbmode
		self.displayer.set_cmode = self.set_cmode
		self.displayer.install_colormap = self.install_colormap
		self.frame = parent.CreateForm('frame', args)
		self.frame.ManageChild()
		self.create_widget()

	def set_rgbmode(self):
		if self.rgbmode: return
		self.rgbmode = 1
		# Recreate the widget in rgb mode
		self.glx.UnmanageChild()
		self.glx.DestroyWidget()
		self.create_widget()

	def set_cmode(self):
		if not self.rgbmode: return
		self.rgbmode = 0
		# Recreate the widget in colormap mode
		self.glx.DestroyWidget()
		self.create_widget()

	def install_colormap(self, map):
		print 'XXX install_colormap in Glx widget not yet supported'

	def create_widget(self):
		self.ginited = 0
		self.framedata = None
		args = {}
		self.params = self.displayer.getinfo()
		width, height = self.params[1], self.params[2]
		if width == 0:
			if height == 0:
				width = 256
			else:
				width = height*4/3
		if height == 0:
			height = width*3/4
		args['width'] = width
		args['height'] = height
		args['glxConfig'] = Glx.makeconfig(
			  [(GLX.NORMAL, GLX.RGB, self.rgbmode)])
		self.glx = self.frame.CreateWidget('glx', Glx.Draw, args)
		self.glx.AddCallback('ginitCallback', self.cb_ginit, None)
		self.glx.AddCallback('exposeCallback', self.cb_expose, None)
		self.glx.AddCallback('resizeCallback', self.cb_resize, None)
		self.glx.AddCallback('inputCallback', self.cb_input, None)
		self.glx.ManageChild()

	def set_expose_hook(self, expose_hook):
		self.expose_hook = expose_hook

	def setsourceparams(self, params):
		self.params = params
		width, height = params[1], params[2]
		self.glx.SetValues({'width': width, 'height': height})
		if self.ginited:
			self.setup()

	def putframe(self, framedata):
		self.framedata = framedata
		if self.ginited:
			self.drawframe()

	def getfilled(self):
		return 0

	def getfillable(self):
		return 1

	def reset(self):
		return 0

	def setup(self):
		Glx.winset(self.glx)
		self.displayer.setinfo(self.params)
		self.displayer.initcolormap()
		self.ginited = 1
		self.drawframe()

	def drawframe(self):
		Glx.winset(self.glx)
		if self.framedata:
			data, chromdata = self.framedata[1:3]
			self.displayer.showframe(data, chromdata)
		else:
			self.displayer.clear()

	def cb_ginit(self, *args):
		pass

	def cb_expose(self, *args):
		if not self.ginited:
			self.setup()
		else:
			Glx.winset(self.glx)
			self.drawframe()
		if self.expose_hook:
			self.expose_hook()

	def cb_resize(self, *args):
		pass

	def cb_input(self, *args):
		pass

class GlxVideoSinkWithSource(GlxVideoSink):

	def __init__(self, parent, args):
		self.vin = None
		GlxVideoSink.__init__(self, parent, args)

	def setvin(self, vin):
		self.putframe(None)
		self.vin = vin
		self.setsourceparams(self.vin.getinfo())
		if self.ginited:
			self.nextframe()

	def cb_expose(self, *args):
		new = (not self.ginited)
		GlxVideoSink.cb_expose(self)
		if new and self.ginited:
			self.nextframe()

	def nextframe(self, *args):
		try:
			framedata = self.vin.getnextframe()
		except EOFError:
			self.vin.rewind()
			try:
				framedata = self.vin.getnextframe()
			except EOFError:
				framedata = None
		if self.framedata:
			told = self.framedata[0]
		else:
			told = 0
		self.putframe(framedata)
		if self.framedata:
			tnew = self.framedata[0]
		else:
			tnew = 0
		tout = max(0, tnew-told)
		tid = Xt.AddTimeOut(tout, self.nextframe, None)

def prconfig(config):
	import GLX
	names = dir(GLX)
	for buffer, mode, arg in config:
		for name in names:
			if getattr(GLX, name) == buffer:
				print 'GLX_' + name,
				break
		else:
			print buffer,
		for name in names:
			if getattr(GLX, name) == mode:
				print 'GLX_' + name,
				break
		else:
			print mode,
		print arg

def test():
	import sys
	if sys.argv[0] == '-c': sys.argv[0] = 'GlxVideoSink_test'
	file = '/ufs/guido/src/video/data/koffie.video'
	v = VFile.VinFile(file)
	t = Xt.Initialize('T', [], sys.argv)
	g = GlxVideoSinkWithSource(t, {})
	g.setvin(v)
	t.RealizeWidget()
	Xt.MainLoop()
