# Audio player class.

# This is an almost trivial extension of BasePlayer: all it does is
# automatically figure out which sink class to use.  (In the future,
# some audio-specific functionality may be moved here from BasePlayer.)

import Xt

from BasePlayer import BasePlayer

# Try to figure out which audio interface to use

def tryinterface(device, interface):
	result = None
	try:
		print 'try import', device
		exec('import ' + device)
		print 'try import', interface
		exec('import ' + interface +
		     '; result = ' + interface + '.' + interface)
		print 'OK'
	except ImportError:
		print 'Not OK'
		pass
	return result

class AudioPlayer(BasePlayer):

	def __init__(self, parent, args):
		sinkClass = None
		if not sinkClass:
			if 0: # Hack for "freeze"
				import al, SGIAudioSink
			sinkClass = tryinterface('al', 'SGIAudioSink')
		if not sinkClass:
			if 0: # Hack for "freeze"
				import sunaudiodev, SunAudioSink
			sinkClass = tryinterface('sunaudiodev', 'SunAudioSink')
		if not sinkClass:
			raise ImportError, 'no suitable audio sink class found'
		BasePlayer.__init__(self, parent, args, sinkClass())

	def initplayer(self):
		self.time_id = None

	def is_playing(self):
		return (not not self.time_id)

	def start_player(self):
		if not self.time_id:
			self.sink.setsourceparams(
				  self.source.getsourceparams())
			self.timeout_action()

	def stop_player(self):
		if self.time_id:
			Xt.RemoveTimeOut(self.time_id)
			self.time_id = None
			n = self.sink.reset()
			if n > 0:
				self.source.seek(self.source.tell() - n)
			self.showinfo()

	def timeout_action(self, *rest):
		self.time_id = None
		left = self.source.getnframes() - self.source.tell()
		nbytes = min(left, self.sink.getfillable())
		if nbytes <= 0:
			if left <= 0 and self.sink.getfilled() == 0:
				self.sink.close()
				self.showinfo()
			else:
				self.next_timeout()
			return
		data = self.source.readframes(nbytes)
		if not data and self.sink.getfilled() == 0:
			# Oops, ran out of data prematurely.
			self.sink.close()
			self.showinfo()
			return
		self.sink.writeframes(data)
		self.next_timeout()

	def next_timeout(self):
		# Set the timeout at half the queue size, in milliseconds
		qsize = self.sink.getfilled() + self.sink.getfillable()
		tout = self.source.getframerate() * 500 / qsize
		# Update at least 10 times/sec for smooth slider movement
		# Update at most 100 times/sec to avoid thrashing
		tout = max(10, min(100, tout))
		self.time_id = Xt.AddTimeOut(tout, self.timeout_action, None)
		self.showinfo()

def test():
	import Xt
	import sys
	if sys.argv[0] == '-c': sys.argv[0] = 'AudioPlayer_test'
	t = Xt.Initialize('AudioPlayer', [], sys.argv)
	p = AudioPlayer(t, {})
	from GenericAudioSource import open
##	file = '/usr/local/sounds/au/klaxon.au'
	file = '/usr/local/sounds/aiff/1999_intro.aiff'
	s = open(file)
	p.set_source(s)
	t.RealizeWidget()
	Xt.MainLoop()
