import Window
import pyclbr
import sys

browsers = {}

class Browser:
	def __init__(self, module, path):
		moddict = pyclbr.readmodule(module, path)
		classes = moddict.keys()
		classes.sort()
		w = Window.Window('Module %s' % module, resizable = 1,
				  deleteCallback = (self.close, ()))
		menu = w.PulldownMenu(
			[('File', [('Open...', (self.open_cb, ())),
				   ('Close', (self.close, ())),
				   None,
				   ('Quit', (sys.exit, (0,)))])],
			top = None, left = None, right = None)
		m_list = w.List('Method list:', [], (self.m_cb, ()),
				top = menu, right = None, bottom = None,
				left = .33, width = 470)
		cl_list = w.List('Class list:', classes, (self.cl_cb, ()),
				 left = None, top = menu, right = m_list,
				 rows = 16, width = 235)
		inh_list = w.List('Inheritance list:', [], (self.inh_cb, ()),
				  left = None, top = cl_list, bottom = None,
				  right = m_list, rows = 5, width = 235)
		w.show()
		self.window = w
		self.m_list = m_list
		self.cl_list = cl_list
		self.inh_list = inh_list
		self.classes = classes
		self.moddict = moddict
		self.module = module
		self.path = path
		self.viewedfile = ''
		self.classes_list = []

		self.twindow_top = w = Window.Window('text', resizable = 1,
						     deleteCallback = 'hide')
		b = w.ButtonRow([('Dismiss', (self.twindow_top.hide, ())),
				 ('Edit', (self.editfile, ()))],
				top = None, left = None, right = None,
				vertical = 0)
		self.twindow = w.TextEdit('', None,
					  top = b, left = None, right = None,
					  bottom = None, columns = 80,
					  rows = 24, editable = 0)
		browsers[module] = self

	def close(self):
		try:
			del browsers[self.module]
		except AttributeError:
			pass
		self.window.close()
		self.twindow_top.close()
		del self.window, self.m_list, self.cl_list, self.inh_list
		del self.classes, self.moddict, self.module, self.path
		del self.twindow_top, self.twindow
		if not browsers:
			# we were the last one, so shutdown completely
			sys.exit(0)

	def open_cb(self):
		w = Window.Window('Open module', grab = 1,
				  deleteCallback = 'close')
		s = w.TextInput('Open module:', '', None, (self.open_done, ()),
				top = None, bottom = None, left = None,
				right = None)
		w.show()
		self.wopen = w
		self.twopen = s

	def open_done(self):
		module = self.twopen.gettext()
		self.wopen.close()
		del self.wopen
		del self.twopen
		if not module:
			return
		Browser(module, self.path)

	def cl_cb(self):
		pos = self.cl_list.getselected()
		if pos is None:
			return
		name = self.cl_list.getlistitem(pos)
		cl = self.moddict[name]
		self.inh_list.delalllistitems()
		classes = super(cl)
		l = []
		for c in classes:
			if type(c) is type(''):
				s = c
			else:
				s = c.name
			if c is classes[0]:
				star = '*'
			else:
				star = ' '
			s = '%s  %s' % (star ,s)
			l.append(s)
		self.inh_list.addlistitems(l, 0)
		self.classes_list = classes
		self.update_m_list()

	def inh_cb(self):
		pos = self.inh_list.getselected()
		if pos is None:
			return
		name = self.inh_list.getlistitem(pos)
		star = name[0]
		if star == '*':
			star = ' '
		else:
			star = '*'
		name = name[3:]
		self.inh_list.replacelistitem(pos, '%s  %s' % (star, name))
		self.update_m_list()

	def m_cb(self):
		import string
		pos = self.m_list.getselected()
		if pos is None:
			return
		name = self.m_list.getlistitem(pos)
		[name, clname] = string.split(name)
		clname = clname[1:-1]
		cl = self.moddict[clname]
		lineno = cl.methods[name]
		file = cl.file
		if file != self.viewedfile:
			try:
				f = open(file).read()
			except IOError:
				return
			self.twindow.settext(f)
			self.viewedfile = file
		self.twindow_top.show()
		self.twindow.scrolltext(lineno-1, Window.TOP)
		self.viewedline = lineno
		line = self.twindow.getline(lineno-1)
		start = string.find(line, name)
		if start >= 0:
			self.twindow.selectchars(lineno-1, start,
						 start + len(name))
		self.twindow_top.settitle('%s.%s.%s' % (self.module, clname,
							name))

	def editfile(self):
		import os
		try:
			editor = os.environ['WINEDITOR']
		except KeyError:
			try:
				editor = os.environ['EDITOR']
			except KeyError:
				editor = 'vi'
			editor = 'xterm -e %s' % editor
		dummy = os.system('%s +%d %s &' % (editor, self.viewedline,
						   self.viewedfile))

	def update_m_list(self):
		import string
		l = []
		inh_list = self.inh_list.getlist()
		for pos in range(len(inh_list)):
			entry = inh_list[pos]
			cl = self.classes_list[pos]
			if entry[0] == '*':
				if type(cl) == type(''):
					continue
				module = cl.module
				name = cl.name
				if module != self.module:
					self.inh_list.replacelistitem(
						pos, '   ' + name)
					if browsers.has_key(module):
						b = browsers[module]
					else:
						b = Browser(module, self.path)
					b.select_class(name)
					continue
				l = l + map(lambda x, cl=cl:
					    '%-20s [%s]' % (x, cl.name),
					    cl.methods.keys())
		l.sort()
		self.m_list.delalllistitems()
		self.m_list.addlistitems(l, 0)

	def select_class(self, name):
		try:
			pos = self.classes.index(name)
		except:
			return
		self.cl_list.selectitem(pos)
		self.cl_cb()

def super(cl):
	list = [cl]
	for c in cl.super:
		list[len(list):] = super(c)
	return list

import sys
browser = Browser(sys.argv[1], sys.argv[2:])
Window.Mainloop()
