/***********************************************************
Copyright 1991 by Stichting Mathematisch Centrum, Amsterdam, The
Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

/* Token types */

#define ENDMARKER      0
#define NAME           1
#define NUMBER         2
#define STRING         3
#define NEWLINE                4
#define INDENT         5
#define DEDENT         6
#define LPAR           7
#define RPAR           8
#define LSQB           9
#define RSQB           10
#define COLON          11
#define COMMA          12
#define SEMI           13
#define PLUS           14
#define MINUS          15
#define STAR           16
#define SLASH          17
#define VBAR           18
#define AMPER          19
#define LESS           20
#define GREATER                21
#define EQUAL          22
#define DOT            23
#define PERCENT                24
#define BACKQUOTE      25
#define LBRACE         26
#define RBRACE         27
#define OP             28
#define ERRORTOKEN     29
#define N_TOKENS       30

/* Special definitions for cooperation with parser */

#define NT_OFFSET              256

#define ISTERMINAL(x)          ((x) < NT_OFFSET)
#define ISNONTERMINAL(x)       ((x) >= NT_OFFSET)
#define ISEOF(x)               ((x) == ENDMARKER)


extern char *tok_name[]; /* Token names */
extern int tok_1char PROTO((int));
