// view.h : interface of the CWpyScrollView class
//
/////////////////////////////////////////////////////////////////////////////
//Python is Copyright 1991-1997 by Stichting Mathematisch Centrum,
//Amsterdam, The Netherlands.  See their copyright notice.

//This code is copyright 1994-1997 by James C. Ahlstrom.  See the
//copyright notice in "copyrite.jim" or e-mail jim@interet.com.
// NO WARRANTIES AT ALL.  USE AT YOUR OWN RISK.

class CWpyScrollView : public CScrollView
{
protected:
	DECLARE_DYNCREATE(CWpyScrollView)
	CWpyScrollView();

// Attributes
protected:
	CObArray m_DrawItems;	// Objects to redraw in OnDraw
	int is_printing;

public:
	CObList m_DeleteList;	// Objects to be deleted when View is deleted.

// Operations
public:
	CWpythonDoc* GetDocument();
	void RecordDraw(PyObject *);	// Record objects to be drawn in OnDraw
	void DestroyDrawn(PyObject *);	// Destroy drawn object, remove from list
	void DestroyAllDrawn();		// Remove all drawn objects
	int  FindDrawIndex(PyObject *);	// Find a CDrawItem given a PyObject
	PyObject * GetDrawnObjs(int, int, int);	// Search for an object
	void Redraw(PyObject *);		// Redraw an object
	void MoveDrawn();	// Check position of all objects
	PyObject * ScrollDrawnObjs(long, long, long, long, long, long); //  Scroll
// Overrides
public:
	virtual HWND UnsubclassWindow();
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWpyScrollView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual void OnInitialUpdate();
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CWpyScrollView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

#ifdef MS_WIN16
	WNDPROC* GetSuperWndProcAddr();
#endif

// Generated message map functions
protected:
	//{{AFX_MSG(CWpyScrollView)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnDestroy();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in view.cpp
inline CWpythonDoc* CWpyScrollView::GetDocument()
   { return (CWpythonDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CWpythonEditView view

class CWpythonEditView : public CEditView
{
protected:
	DECLARE_DYNCREATE(CWpythonEditView)
	CWpythonEditView();

// Attributes
public:
	CObList m_DeleteList;	// Objects to be deleted when View is deleted.

// Operations
public:
	void WpyProcessOnChar();

// Overrides
public:
	virtual HWND UnsubclassWindow();
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWpythonEditView)
	public:
	virtual void OnInitialUpdate();
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~CWpythonEditView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

#ifdef MS_WIN16
	WNDPROC* GetSuperWndProcAddr();
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(CWpythonEditView)
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnDestroy();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnRButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

class CDrawItem : public CObject
{
public:
	CRect m_rect;
	PyObject *m_pyobj;
	int m_lineWidth;	// If a line, its width
	BOOL m_pointAtUL;	// If a line, is a point at upper left corner of m_rect?
	char m_type;		// Type of drawn object

	CDrawItem(PyObject *);
	virtual ~CDrawItem();
};

/////////////////////////////////////////////////////////////////////////////
// CWpythonView view

class CWpythonView : public CView
{
public:
	DECLARE_DYNCREATE(CWpythonView)
	CWpythonView();
	virtual ~CWpythonView();

// Attributes
protected:
	CObArray m_DrawItems;	// Objects to redraw in OnDraw
	int is_printing;
	int m_IsSubclassed;		// Prevent multiple un/subclass

public:
	CObList m_DeleteList;	// Objects to be deleted when View is deleted.


// Operations
public:
	BOOL SubclassWindow(HWND);
	virtual HWND UnsubclassWindow();
	void RecordDraw(PyObject *);	// Record objects to be drawn in OnDraw
	void DestroyDrawn(PyObject *);	// Destroy drawn object, remove from list
	void DestroyAllDrawn();		// Remove all drawn objects
	int  FindDrawIndex(PyObject *);	// Find a CDrawItem given a PyObject
	PyObject * GetDrawnObjs(int, int, int);	// Search for an object
	void Redraw(PyObject *);		// Redraw an object
	void MoveDrawn();	// Check position of all objects

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWpythonView)
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);
	//}}AFX_VIRTUAL

// Implementation
protected:


#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

#ifdef MS_WIN16
	WNDPROC* GetSuperWndProcAddr();
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(CWpythonView)
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	afx_msg void OnInitMenuPopup(CMenu * pMenu, UINT u, BOOL b);
#ifdef NETSCAPE_PI
	afx_msg int OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message);
#endif
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
