// template.cpp : implementation file
//

#include "stdafx.h"
#include "template.h"
#include "app.h"

static char * GetFilter(CObject * This, int index)
{
	PyObject * pytempl = theApp.GetPythonObject(This);
	ASSERT(pytempl);
	PyObject * attr;
	char * pt = 0;
	if(attr = PyObject_GetAttrString(pytempl, "wpyFilter")){
		PyObject * obj;
		if (obj = PyTuple_GetItem(attr, index))
			pt = PyString_AsString(obj);
		Py_DECREF(attr);
	}
	else
		PyErr_Clear();
	return pt;
}

/////////////////////////////////////////////////////////////////////////////
// CWpySingleDocTemplate

IMPLEMENT_DYNAMIC(CWpySingleDocTemplate, CSingleDocTemplate)

CWpySingleDocTemplate::CWpySingleDocTemplate(UINT n, CRuntimeClass *d, CRuntimeClass *f, CRuntimeClass *v)
	: CSingleDocTemplate(n, d, f, v)
{
}

CWpySingleDocTemplate::~CWpySingleDocTemplate()
{
}

BOOL CWpySingleDocTemplate::GetDocString(CString& rString, enum DocStringIndex index) const
{
	char * pt;
	switch(index) {
	case CDocTemplate::filterName:
		if (pt = GetFilter((CObject *)this, 0)) {
			rString = pt;
			return 1;
		}
		break;
	case CDocTemplate::filterExt:
		if (pt = GetFilter((CObject *)this, 1)) {
			rString = pt;
			return 1;
		}
		break;
	// case CDocTemplate::windowTitle: Not called!
	//	PyObject * pytempl = theApp.GetPythonObject((CObject*)this);
	//	ASSERT(pytempl);
	//	char * title = GetAttrString(pytempl, "wpyMainTitle");
	//	rString = title;
	//	AfxMessageBox("Main title");
	//	return 1;
	}
	return CSingleDocTemplate::GetDocString(rString, index);
}

CDocument * CWpySingleDocTemplate::OpenDocumentFile(LPCTSTR name, BOOL vis)
{
	PyObject * args;
	if (name)
		args = Py_BuildValue("(sl)", name, vis);
	else
		args = Py_BuildValue("(sl)", "", vis);
	PyObject * ret = theApp.CallPythonRet(this, "OpenDocumentFile", args);
	Py_DECREF(args);
	CDocument * pDoc = (CDocument *) theApp.GetCppObject(ret);
	Py_XDECREF(ret);
	return pDoc;
}

/////////////////////////////////////////////////////////////////////////////
// CWpyMultiDocTemplate

IMPLEMENT_DYNAMIC(CWpyMultiDocTemplate, CMultiDocTemplate)

CWpyMultiDocTemplate::CWpyMultiDocTemplate(UINT n, CRuntimeClass *d, CRuntimeClass *f, CRuntimeClass *v)
	: CMultiDocTemplate(n, d, f, v)
{
}

CWpyMultiDocTemplate::~CWpyMultiDocTemplate()
{
}

BOOL CWpyMultiDocTemplate::GetDocString(CString& rString, enum DocStringIndex index) const
{
	char * pt;
	switch(index) {
	case CDocTemplate::filterName:
		if (pt = GetFilter((CObject *)this, 0)) {
			rString = pt;
			return 1;
		}
		break;
	case CDocTemplate::filterExt:
		if (pt = GetFilter((CObject *)this, 1)) {
			rString = pt;
			return 1;
		}
		break;
	}
	return CMultiDocTemplate::GetDocString(rString, index);
}

CDocument * CWpyMultiDocTemplate::OpenDocumentFile(LPCTSTR name, BOOL vis)
{
	PyObject * args;
	if (name)
		args = Py_BuildValue("(sl)", name, vis);
	else
		args = Py_BuildValue("(sl)", "", vis);
	PyObject * ret = theApp.CallPythonRet(this, "OpenDocumentFile", args);
	Py_DECREF(args);
	CDocument * pDoc = (CDocument *) theApp.GetCppObject(ret);
	Py_XDECREF(ret);
	return pDoc;
}
