// controls.cpp : implementation file
//
//Python is Copyright 1991-1997 by Stichting Mathematisch Centrum,
//Amsterdam, The Netherlands.  See their copyright notice.

//This code is copyright 1994-1997 by James C. Ahlstrom.  See the
//copyright notice in "copyrite.jim" or e-mail jim@interet.com.
// NO WARRANTIES AT ALL.  USE AT YOUR OWN RISK.


#include "stdafx.h"
#include "app.h"
#include "controls.h"
#include "view.h"
#include "globals.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

static void UseParentColor(CWnd * ctrl, WPARAM wParam, LRESULT* pLResult)
{
	// Use white background except for dialogs
	HDC hDC = (HDC)wParam;
	CWnd * parent = ctrl->GetParent();
	if (parent && parent->IsKindOf(RUNTIME_CLASS(CDialog))) {
		::SetBkColor(hDC, RGB(192, 192, 192));	
		*pLResult = (LRESULT) ::GetStockObject(LTGRAY_BRUSH);
	}
	else {
		::SetBkColor(hDC, RGB(255, 255, 255));
		*pLResult = (LRESULT) ::GetStockObject(WHITE_BRUSH);				
	}
}

BOOL ControlColor(CWnd * ctrl, UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pLResult) 
{
	PyObject * pycontrol = theApp.GetPythonObject(ctrl);
	if (!pycontrol)
		return 0;
	HDC hDC = (HDC)wParam;
	PyObject * pybrush, * pycolor;
	BOOL ret = 0;
	if ((pycolor = PyObject_GetAttrString(pycontrol, "wpyTextColor")) != 0){
		PyObject * py = PyTuple_GetItem(pycolor, 0);
		ASSERT(py);
		long r = PyInt_AsLong(py);
		py = PyTuple_GetItem(pycolor, 1);
		ASSERT(py);
		long g = PyInt_AsLong(py);
		py = PyTuple_GetItem(pycolor, 2);
		ASSERT(py);
		long b = PyInt_AsLong(py);
		::SetTextColor(hDC, RGB(r, g, b));
		Py_DECREF(pycolor);
		// Use white background except for dialogs
		if (!ctrl->IsKindOf(RUNTIME_CLASS(CDialog))) {
			CWnd * parent = ctrl->GetParent();
			if (parent && !parent->IsKindOf(RUNTIME_CLASS(CDialog))) {
				::SetBkColor(hDC, RGB(255, 255, 255));			
				*pLResult = (LRESULT) ::GetStockObject(WHITE_BRUSH);
				ret = 1;
			}
		}
		ret = 1;
	}
	else
		PyErr_Clear();
	if ((pybrush = PyObject_GetAttrString(pycontrol, "wpyBrush")) != 0){
		CBrush * pBrush;
		if (pBrush = (CBrush *)theApp.GetCppObject(pybrush)){
			LOGBRUSH lb;
			pBrush->GetObject(sizeof(LOGBRUSH), &lb);
			::SetBkColor(hDC, lb.lbColor);
			*pLResult = (LRESULT) pBrush->GetSafeHandle();
			ret = 1;
		}
		Py_DECREF(pybrush);
	}
	else {
		PyErr_Clear();
		// Use white background except for dialogs
		//if (!ctrl->IsKindOf(RUNTIME_CLASS(CDialog))) {
		//	CWnd * parent = ctrl->GetParent();
		//	if (parent && !parent->IsKindOf(RUNTIME_CLASS(CDialog))) {
		//		*pLResult = (LRESULT) ::GetStockObject(WHITE_BRUSH);
		//		ret = 1;
		//	}
		//}
	}
	return ret;
}

/////////////////////////////////////////////////////////////////////////////
// CWpythonButton

CWpythonButton::CWpythonButton(PyObject *pyobj)
{
	theApp.RecordObjects(this, pyobj, TRUE);
}

CWpythonButton::~CWpythonButton()
{
	theApp.UnRecordCpp(this, TRUE);
}


BEGIN_MESSAGE_MAP(CWpythonButton, CButton)
	//{{AFX_MSG_MAP(CWpythonButton)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWpythonButton message handlers

/////////////////////////////////////////////////////////////////////////////

BOOL CWpythonButton::OnChildNotify(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pLResult) 
{
	switch (message) {
#ifdef MS_WIN16
	case WM_CTLCOLOR:	// Change to messages MFC 2.5 -> 3.0 -> Win95
#else
	case WM_CTLCOLORBTN:
	case WM_CTLCOLORSTATIC:
#endif
		// Ineffective in Windows 95 for command buttons.
		if (!ControlColor(this, message, wParam, lParam, pLResult))
			// Use parent background for check and radio buttons
			if (GetButtonStyle() & (BS_CHECKBOX | BS_RADIOBUTTON | BS_3STATE)){
				UseParentColor(this, wParam, pLResult);
				return 1;
			}
    }
	return 0;
}


// CWpythonStatic

CWpythonStatic::CWpythonStatic(PyObject *pyobj)
{
	theApp.RecordObjects(this, pyobj, TRUE);
}

CWpythonStatic::~CWpythonStatic()
{
	theApp.UnRecordCpp(this, TRUE);
}


BEGIN_MESSAGE_MAP(CWpythonStatic, CStatic)
	//{{AFX_MSG_MAP(CWpythonStatic)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWpythonStatic message handlers

BOOL CWpythonStatic::OnChildNotify(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pLResult) 
{
	switch (message) {
#ifdef MS_WIN16
	case WM_CTLCOLOR:	// Change to messages MFC 2.5 -> 3.0 -> Win95
#else
	case WM_CTLCOLORSTATIC:
#endif
		if (!ControlColor(this, message, wParam, lParam, pLResult))
			UseParentColor(this, wParam, pLResult);			
		return 1; 
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CWpythonScrollBar

CWpythonScrollBar::CWpythonScrollBar(PyObject *pyobj)
{
	theApp.RecordObjects(this, pyobj, TRUE);
}

CWpythonScrollBar::~CWpythonScrollBar()
{
	theApp.UnRecordCpp(this, TRUE);
}


BEGIN_MESSAGE_MAP(CWpythonScrollBar, CScrollBar)
	//{{AFX_MSG_MAP(CWpythonScrollBar)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWpythonScrollBar message handlers

/////////////////////////////////////////////////////////////////////////////

BOOL CWpythonScrollBar::OnChildNotify(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pLResult) 
{
	switch (message) {
#ifdef MS_WIN16	
	case WM_CTLCOLOR:	// Change to messages MFC 2.5 -> 3.0
#else
	case WM_CTLCOLORSCROLLBAR:
#endif
		return ControlColor(this, message, wParam, lParam, pLResult); 
	}
	return 0;
}


/////////////////////////////////////////////////////////////////////////////
// CWpythonListBox
IMPLEMENT_DYNAMIC(CWpythonListBox, CListBox)

CWpythonListBox::CWpythonListBox(PyObject *pyobj)
{
	theApp.RecordObjects(this, pyobj, TRUE);
}

CWpythonListBox::~CWpythonListBox()
{
	theApp.UnRecordCpp(this, TRUE);
}


BEGIN_MESSAGE_MAP(CWpythonListBox, CListBox)
	//{{AFX_MSG_MAP(CWpythonListBox)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWpythonListBox message handlers
/////////////////////////////////////////////////////////////////////////////

BOOL CWpythonListBox::OnChildNotify(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pLResult) 
{
	switch (message) {
#ifdef MS_WIN16	
	case WM_CTLCOLOR:	// Change to messages MFC 2.5 -> 3.0 -> Win95
#else
	case WM_CTLCOLORLISTBOX:
#endif
		return ControlColor(this, message, wParam, lParam, pLResult); 
	}
	return 0;
}

// CWpythonEdit

CWpythonEdit::CWpythonEdit(PyObject * pyobj)
{
	theApp.RecordObjects(this, pyobj, TRUE);
}

CWpythonEdit::~CWpythonEdit()
{
	theApp.UnRecordCpp(this, TRUE);
}


BEGIN_MESSAGE_MAP(CWpythonEdit, CEdit)
	//{{AFX_MSG_MAP(CWpythonEdit)
	ON_WM_CHAR()
	ON_WM_KILLFOCUS()
	ON_WM_SETFOCUS()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONDBLCLK()
	ON_WM_RBUTTONUP()
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWpythonEdit message handlers

void CWpythonEdit::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (WpyOnChar(this, nChar, nRepCnt, nFlags))
		CEdit::OnChar(nChar, nRepCnt, nFlags);
}

void CWpythonEdit::OnKillFocus(CWnd* pNewWnd) 
{
	CEdit::OnKillFocus(pNewWnd);
	
	// TODO: Add your message handler code here
	
}

void CWpythonEdit::OnSetFocus(CWnd* pOldWnd) 
{
	CEdit::OnSetFocus(pOldWnd);
	
	// TODO: Add your message handler code here
	
}

BOOL CWpythonEdit::OnChildNotify(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pLResult) 
{
	switch (message) {
#ifdef MS_WIN16
	case WM_CTLCOLOR:	// Change to messages MFC 2.5 -> 3.0 -> Win95
#else
	case WM_CTLCOLOREDIT:
#endif
		return ControlColor(this, message, wParam, lParam, pLResult); 
	}
	return 0;
}




/////////////////////////////////////////////////////////////////////////////
// CWpythonComboBox
IMPLEMENT_DYNAMIC(CWpythonComboBox, CComboBox)

CWpythonComboBox::CWpythonComboBox(PyObject * pyobj)
{
	theApp.RecordObjects(this, pyobj, TRUE);
}

CWpythonComboBox::~CWpythonComboBox()
{
	theApp.UnRecordCpp(this, TRUE);
}


BEGIN_MESSAGE_MAP(CWpythonComboBox, CComboBox)
	//{{AFX_MSG_MAP(CWpythonComboBox)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWpythonComboBox message handlers

BOOL CWpythonComboBox::OnChildNotify(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pLResult) 
{
	switch (message) {
#ifdef MS_WIN16	
	case WM_CTLCOLOR:	// Change to messages MFC 2.5 -> 3.0 -> Win95
#else
	case WM_CTLCOLORLISTBOX:
#endif
		return ControlColor(this, message, wParam, lParam, pLResult); 
	}
	return 0;
}

void CWpythonEdit::OnRButtonDown(UINT nFlags, CPoint point) 
{
	WpyMouse(this, nFlags, point, "OnRButtonDown");
	CEdit::OnRButtonDown(nFlags, point);
}

void CWpythonEdit::OnRButtonDblClk(UINT nFlags, CPoint point) 
{
	WpyMouse(this, nFlags, point, "OnRButtonDblClk");
	CEdit::OnRButtonDblClk(nFlags, point);
}

void CWpythonEdit::OnRButtonUp(UINT nFlags, CPoint point) 
{
	WpyMouse(this, nFlags, point, "OnRButtonUp");
	CEdit::OnRButtonUp(nFlags, point);
}

void CWpythonEdit::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (WpyOnVChar(this, nChar, nRepCnt, nFlags))
		CEdit::OnKeyDown(nChar, nRepCnt, nFlags);
}

BOOL CWpythonEdit::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo) 
{
	if (nID >= COMMAND_BASE_SEQ && nID <= COMMAND_MAX_SEQ) switch(nCode){
	case CN_COMMAND:
		theApp.CallPython(nID, "WpyPhysOnCommand");
		return( TRUE );
	case CN_UPDATE_COMMAND_UI:
		theApp.PyOnCommandUI( (CCmdUI*)pExtra );
		return( TRUE );
	}
	return CEdit::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}
