// app.cpp : Defines the class behaviors for the application.
//
//Python is Copyright 1991-1997 by Stichting Mathematisch Centrum,
//Amsterdam, The Netherlands.  See their copyright notice.

//This code is copyright 1994-1997 by James C. Ahlstrom.  See the
//copyright notice in "copyrite.jim" or e-mail jim@interet.com.
// NO WARRANTIES AT ALL.  USE AT YOUR OWN RISK.


#include "stdafx.h"
#include "app.h"

#include "multmain.h"
#include "snglmain.h"
#include "dialog.h"
#include "doc.h"
#include "view.h"
#include "controls.h"
#include "util.h"
#include "resource.h"
#include <sys/timeb.h>

extern "C" void initwpy_nt();
extern "C" void initnspi();

static HINSTANCE hDllFrozen = 0;

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

static void freedll()
{
	FreeLibrary(hDllFrozen);
}

extern "C" void flushMsg()
{
	((CWpythonApp *)AfxGetApp())->FlushMessages();
}

/////////////////////////////////////////////////////////////////////////////
// CWpythonApp

BEGIN_MESSAGE_MAP(CWpythonApp, CWinApp)
	//{{AFX_MSG_MAP(CWpythonApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWpythonApp construction

CWpythonApp::CWpythonApp()
{
	m_pNetscapeView = 0;
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CWpythonApp object

CWpythonApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CWpythonApp initialization

BOOL CWpythonApp::InitInstance()
{
	char * pt;
	// Parse command line
	char * ptargs = (char *) malloc(strlen(m_lpCmdLine) + 2);
	strcpy(ptargs + 1, m_lpCmdLine);
	*ptargs = 0;	// prepend a null byte
	pt = ptargs + 1;
	// Break command line apart at blanks
	int maxargs = 5;
	char ** argv = (char **) malloc(maxargs * sizeof(char *));
	argv[0] = "";	// Save space for executable name
	int nargs = 0, narg_filename = 0;
	char * filename = 0;
	while (*pt) {
		if (*pt != ' '){
			if (*(pt - 1) == 0){
				nargs++;
				if (nargs + 1 >= maxargs) {
					maxargs += 5;
					argv = (char **) realloc(argv, maxargs * sizeof(char *));
				}
				argv[nargs] = pt;
			}
		}
		else {
			*pt = 0;
		}
		pt ++;
	}// There are now nargs+1 elements in argv[]
	int i, l;
	for (i = 1; i <= nargs; i++) {
		l = strlen(argv[i]);
		if (*argv[i] != '-' &&
		(!strcmp(argv[i] + l - 3, ".py") ||
		 !strcmp(argv[i] + l - 4, ".pyc"))) {
				narg_filename = i;
				filename = argv[i];
				break;
		}
	}

	// Get our executable name, and look for a DLL with that name
	char argv0[256], buf256[256];
	if (GetModuleFileName(AfxGetInstanceHandle(), argv0, 256) == 0) {
		strcpy(argv0, "Unknown");
	}
	else {
		strcpy(buf256, argv0);
		char * pt = buf256 + strlen(buf256) - 1;
		while (pt > buf256 && *pt != '.')
			pt--;	// throw away ".exe"
		pt++;		// add ".dll"
		*pt++ = 'd';
		*pt++ = 'l';
		*pt++ = 'l';
		*pt = 0;
		while (pt > buf256 && *pt != '/' && *pt != '\\' && *pt != ':')
			pt--;	// space over the exe name (stop at path)
		pt++;
		//Look for a frozen modules DLL with our executable name
		hDllFrozen = LoadLibrary(pt);
#ifdef MS_WIN16
		if (hDllFrozen > HINSTANCE_ERROR) {
#else
		if (hDllFrozen != 0) {
#endif
			atexit(freedll);	// Release DLL at exit
			struct _frozen ** ppt = (struct _frozen **) GetProcAddress(hDllFrozen, "PyImport_FrozenModules");
			if (ppt)
				PyImport_FrozenModules = *ppt;
			// Try to use resources from the DLL instead of our resources
			if (FindResource(hDllFrozen, (LPCTSTR)IDD_DIALOG1, RT_DIALOG))
				AfxSetResourceHandle(hDllFrozen);
		}
	}

	// Standard initialization

#ifdef NETSCAPE_PI		// Netscape plugin
	free((void*)theApp.m_pszProfileName);
	theApp.m_pszProfileName = _tcsdup(_T("wpython.ini"));
	theApp.m_pMainWnd = new CFrameWnd();
#else
	SetDialogBkColor();
#ifndef MS_WIN16	
	Enable3dControls();		// Not available in MFC 2.5
#endif
#endif

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Must initialize Python
	Py_Initialize();

	// Start WPY
	initwpy_nt();

	if (!narg_filename)
		argv[0] = argv0;	// Install executable name

	// For script, the script name is argv[0]
	PySys_SetArgv(nargs - narg_filename + 1, argv + narg_filename);

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.
#ifdef NETSCAPE_PI		// No default program for Netscape Plugin
	initnspi();
#else
	// Py_AtExit(flushMsg);
	if (!filename){
		int n = PyImport_ImportFrozenModule("__main__");
		if (n == 0) { // __main__ was not frozen
			PyRun_SimpleString("import wpyinter");
		}
		else if (n < 0) {
			PyErr_Print();
		}
		else {
		}
	}
	else{
		FILE *fp;
		if ((fp = fopen(filename, "r")) == NULL) {
			CString msg;
			msg.Format("Can not open the file %s.", filename);
			AfxMessageBox(msg);
			return FALSE;
		}
		else{
			PyRun_SimpleFile(fp, filename);
			fclose(fp);
		}
	}
	free(argv);
	free(ptargs);

	PyObject * wpyAppInstance = GetPythonObject(this);
	if (wpyAppInstance) {
		PyObject * v = PyInt_FromLong((long)AfxGetInstanceHandle());
		PyObject_SetAttrString(wpyAppInstance, "wpyWinhInstance", v);
		PyObject * md = PySys_GetObject("modules");	// Return module dict
		m_ModuleWpy = PyDict_GetItemString(md, "wpy");
		if (!m_ModuleWpy) {
			AfxMessageBox("Cannot find the module wpy.");
			return FALSE;
		}
		PyObject * arg = Py_BuildValue("(s)", argv0);
		PyObject * ret = CallPythonRet(this, "WpyphysInitInstance", arg);
		Py_DECREF(arg);
		FlushMessages();
		if (!ret)
			return FALSE;
		if (PyInt_Check(ret) && PyInt_AsLong(ret) == 0)
			return FALSE;
		Py_DECREF(ret);
		free((void*)m_pszAppName);
		m_pszAppName = _tcsdup(_T(GetAttrString(wpyAppInstance, "wpyText")));
	}
	else {
		FlushMessages();
		return FALSE;
	}
#endif
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CWpythonApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CWpythonApp commands


// Python dictionary access methods

PyObject *
CWpythonApp::GetPythonObject(CObject *CppObject)
{
	void * vpt;
	if (!m_CppToPython.Lookup(CppObject, vpt))
		return NULL;
	return (PyObject *) vpt;
}

PyObject *
CWpythonApp::GetPythonControl(UINT id)
{
	void * vpt;
	if (!m_ControlToPython.Lookup(id, vpt))
		return NULL;
	return (PyObject *) vpt;
}

CObject *
CWpythonApp::GetCppObject(PyObject * PythonObject)
{
	void * vpt;
	if (!m_PythonToCpp.Lookup(PythonObject, vpt))
		return NULL;
	return (CObject *) vpt;

}

void CWpythonApp::SetPythonTemplate(PyObject *t){
	m_python_template = t;
	m_python_view = PyObject_GetAttrString(m_python_template, "wpyView");
	ASSERT(m_python_view);
}

void CWpythonApp::RecordObjects(CObject *cpp_obj, PyObject *py_obj, int do_incref)
{
	if (py_obj == Py_None)
		return;
	m_PythonToCpp[py_obj] = cpp_obj;
	m_CppToPython[cpp_obj] = py_obj;
	// If C++ creates/deletes the object, do_incref == TRUE.
	// If Python creates/deletes the object, do_incref == FALSE.
	if (do_incref)
		Py_XINCREF(py_obj);	// Used to preserve the Python object
}

void CWpythonApp::RecordControl(UINT id, PyObject *py_obj)
{
	if (py_obj == Py_None)
		return;
	m_ControlToPython[id] = py_obj;
	m_PythonToControl[py_obj] = id;
	// No INCREF because Python PyObject is already recorded
	// in the Cpp to Python dictionary.
}

void CWpythonApp::UnRecordCpp(CObject * cpp_obj, int do_decref)
{
	void * vpt;
	WORD id;
	if (m_CppToPython.Lookup(cpp_obj, vpt)){
		m_CppToPython.RemoveKey(cpp_obj);
		m_PythonToCpp.RemoveKey(vpt);
		if (do_decref)
			Py_XDECREF((PyObject *)vpt);
		if (m_PythonToControl.Lookup(vpt, id)){
			m_PythonToControl.RemoveKey(vpt);
			m_ControlToPython.RemoveKey(id);
		}
	}
}

int CWpythonApp::CallPython(CObject *obj, char *name)
{	// call the Python method named "name" for "obj".
	// return 1 for success, 0 for failure.
	PyObject * pPyObj = GetPythonObject(obj);
	return CallPython(pPyObj, name);
}

int CWpythonApp::CallPython(CObject *obj, char *name, PyObject *args)
{	// call the Python method named "name" for "obj".
	// return 1 for success, 0 for failure.
	PyObject * pPyObj = GetPythonObject(obj);
	return CallPython(pPyObj, name, args);
}

int CWpythonApp::CallPython(UINT id, char *name)
{	// call the Python method named "name" for control with id "id"
	// return 1 for success, 0 for failure.
	PyObject * pPyObj = GetPythonControl(id);
	return CallPython(pPyObj, name);
}

int CWpythonApp::CallPython(UINT id, char *name, PyObject *args)
{	// call the Python method named "name" for control with id "id"
	// return 1 for success, 0 for failure.
	PyObject * pPyObj = GetPythonControl(id);
	return CallPython(pPyObj, name, args);
}

int CWpythonApp::CallPython(PyObject *pPyObj, char *name)
{
	PyObject *args = Py_BuildValue("()");
	int ret = CallPython(pPyObj, name, args);
	Py_DECREF(args);
	return ret;
}

int CWpythonApp::CallPython(PyObject *pPyObj, char *name, PyObject * args)
{	// call the Python method named "name" for "obj".
	// return 1 for success, 0 for failure.
	PyObject * ret = CallPythonRet(pPyObj, name, args);
	if (ret){
		Py_DECREF(ret);
		return 1;
	}
	else
		return 0;
}

PyObject * CWpythonApp::CallPythonRet(PyObject *pPyObj, char *name, PyObject * args)
{	// Call the Python method named "name" for "obj".
	// The "args" may be NULL.
	// Return the python result for success, 0 for failure.
	// It is not an error if the method does not exist, but 0 is returned.
	// If the method exists, but the call fails, it is a Python error.
	if (!pPyObj){
		return 0;
	}
	PyObject *method = PyObject_GetAttrString(pPyObj, name);
	if (method){
		PyObject *res = PyEval_CallObject (method, args);
		Py_DECREF(method);
		if (res){
			return res;
		}
		else{
			PyErr_Print();
		}
	}
	else
		PyErr_Clear();
	return 0;
}

PyObject * CWpythonApp::CallPythonRet(CObject *obj, char *name, PyObject * args)
{
	PyObject * pPyObj = GetPythonObject(obj);
	return CallPythonRet(pPyObj, name, args);
}

void CWpythonApp::AddToDeleteList(CWnd * window, CWnd * control)
{	// Record control for eventual deletion.
	if (window->IsKindOf(RUNTIME_CLASS(CWpyScrollView)))
		((CWpyScrollView *)window)->m_DeleteList.AddTail(control);
	else if (window->IsKindOf(RUNTIME_CLASS(CWpythonDialog)))
		((CWpythonDialog *)window)->m_DeleteList.AddTail(control);
	else if (window->IsKindOf(RUNTIME_CLASS(CWpythonView)))
		((CWpythonView *)window)->m_DeleteList.AddTail(control);
}

void CWpythonApp::Py_abort()
{
	FlushMessages();
	if (m_pMainWnd)
		m_pMainWnd->DestroyWindow();
}

void CWpythonApp::FlushMessages()
{
	static int reentry = 0;

	reentry++;
	if (!m_StdOutText.IsEmpty() && reentry == 1){
		CString msg;	// Print multiline message in blocks
		int i, count = 0, len = m_StdOutText.GetLength();
		char ch;
		for (i = 0; i < len; i++){
			ch = m_StdOutText[i];
			msg += ch;
			if (ch == '\n' && ++count > 20) {
				count = 0;
				if (AfxMessageBox(msg, MB_OKCANCEL | MB_ICONEXCLAMATION) == IDCANCEL){
					msg.Empty();
					break;
				}
				msg.Empty();
			}
		}
		if (!msg.IsEmpty())
			AfxMessageBox(msg, MB_ICONEXCLAMATION);
		m_StdOutText.Empty();
	}
	reentry--;	
}

int CWpythonApp::ExitInstance() 
{
	TRACE0("app.cpp: Entered ExitInstance\r\n");
	theApp.CallPython(this, "WpyPhysExitInstance");
	FlushMessages();
	void * pyobj, * cppobj;
	POSITION pos = m_PythonToCpp.GetStartPosition();
	while(pos){
		m_PythonToCpp.GetNextAssoc(pos, pyobj, cppobj);
		if (pyobj && cppobj){
			char * name = GetAttrString((PyObject *)pyobj, "wpyClassName");
			if (name){
				if (!strcmp(name, "Brush"))
					delete (CBrush *)cppobj;
				else if (!strcmp(name, "Font"))
					delete (CWpyFont *)cppobj;
				else if (!strcmp(name, "Pen"))
					delete (CPen *)cppobj;
			}
		}
	}
	int ret = CWinApp::ExitInstance();
	//freedll();
#ifdef NETSCAPE_PI		// Static MFC DLL: defined for Netscape Plugin
	delete theApp.m_pMainWnd;
	theApp.m_pMainWnd = 0;
#endif
	return ret;
}

BOOL CWpythonApp::OnIdle(LONG lCount) 
{
	if (CWinApp::OnIdle(lCount))
		return TRUE;
	FlushMessages();
	if (lCount < 10)
		return TRUE;
	long ret;
	PyObject * pyobj = CallPythonRet(this, "WpyPhysOnIdle", NULL);
	if (pyobj && PyInt_Check(pyobj))
		ret = PyInt_AsLong(pyobj);
	else
		ret = FALSE;
	Py_XDECREF(pyobj);
	return ret;
}

BOOL CWpythonApp::PyOnCommand( WPARAM wParam, LPARAM lParam )
{
	UINT nID = LOWORD(wParam);
#ifdef NT
	UINT notify = HIWORD(wParam);
	HWND hWnd   = (HWND)lParam;
#else
	UINT notify = HIWORD(lParam);
	HWND hWnd   = (HWND)LOWORD(lParam);
#endif
	switch(nID) {
	case ID_WRITE_STDOUT:
		FlushMessages();
		return TRUE;
	case WPY_CLOSEUP:
		CallPython(LOWORD(lParam), "WpyPhysOnCloseup");
		return TRUE;
	}
 	if (nID >= CONTROL_BASE_SEQ && nID <= CONTROL_MAX_SEQ)
		switch(notify) {
 		case BN_CLICKED:
			CallPython(nID, "WpyPhysOnButton");
 			return( TRUE );
 		case CBN_CLOSEUP:
			// Must allow time to GetWindowText() to be valid
			m_pMainWnd->PostMessage(WM_COMMAND, WPY_CLOSEUP, nID);
 			return( FALSE );
 		case LBN_SELCHANGE:
			OnListBox(nID, "WpyPhysOnListBox");
 			return( TRUE );
 		case LBN_DBLCLK:
			OnListBox(nID, "WpyPhysOnListBoxDbl");
 			return( TRUE );
 		case EN_CHANGE:
 		case CBN_EDITCHANGE:
			CallPython(nID, "WpyPhysOnEditChange");
 			return( FALSE );
 		case EN_HSCROLL:
			CallPython(nID, "WpyPhysOnHScroll");
 			return( FALSE );
 		case EN_VSCROLL:
			int pos = (int)::SendMessage(hWnd, EM_GETFIRSTVISIBLELINE, 0, 0);
			PyObject * arg = Py_BuildValue("(i)", pos);
			CallPython(nID, "WpyPhysOnVScroll", arg);
			Py_DECREF(arg);
 			return( FALSE );
 		}
 	return FALSE;
}

BOOL CWpythonApp::OnCmdMsg( UINT nID, int nCode, void* pExtra, 
	AFX_CMDHANDLERINFO* pHandlerInfo )
{
	if (nID >= COMMAND_BASE_SEQ && nID <= COMMAND_MAX_SEQ) switch(nCode){
	case CN_COMMAND:
		CallPython(nID, "WpyPhysOnCommand");
		return( TRUE );
	case CN_UPDATE_COMMAND_UI:
		CallPython(nID, "WpyPhysOnCommandUI");
		this->PyOnCommandUI( (CCmdUI*)pExtra );
		return( TRUE );
	}
	return CWinApp::OnCmdMsg( nID, nCode, pExtra, pHandlerInfo);
}

void CWpythonApp::PyOnCommandUI(CCmdUI* pCmdUI)
{
	UINT nID = pCmdUI->m_nID;
	PyObject * pPyObj = GetPythonControl(nID);
	if (pPyObj){
		long value;
		if (GetAttrLong(pPyObj, "wpyphysMenuFlags", &value)){
			if (value & MF_GRAYED)
				pCmdUI->Enable(FALSE);
			else
				pCmdUI->Enable(TRUE);
			if (value & WPY_MF_CHECKBOX){
				if (value & MF_CHECKED)
					pCmdUI->SetCheck(1);
				else
					pCmdUI->SetCheck(0);
			}
			else if (value & WPY_MF_RADIOBUTTON){
				if (value & MF_CHECKED)
					// pCmdUI->SetRadio(1);  Ugly
					pCmdUI->SetCheck(1);
				else
					// pCmdUI->SetRadio(0);
					pCmdUI->SetCheck(0);
			}
		}
	}
}

BOOL CWpythonApp::WpyGetMessageString(UINT id, CString& string)
{
	PyObject * pyobj;
	char * s;
	if (id >= COMMAND_BASE_SEQ && id <= COMMAND_MAX_SEQ &&
		(pyobj = GetPythonControl(id)) &&
		(s = GetAttrString(pyobj, "wpyMessage"))){
			string = s;
			return 1;
		}
	return 0;
}

void CWpythonApp::OnListBox(UINT nID, char * func)
{
	PyObject * py = GetPythonControl(nID);
	CWpythonListBox * lb = (CWpythonListBox *) GetCppObject(py);
	ASSERT(lb);
	int sel = lb->GetCurSel();
	PyObject * arg;
	if (sel == LB_ERR)
		sel = -1;
	arg = Py_BuildValue("(i)", sel);
	CallPython(py, func, arg);
	Py_DECREF(arg);
}

void CWpythonApp::SetUpDC(CDC * pDC, PyObject * pydc)
{
	CPen * pPen;
	CBrush * pBrush;
	CWpyFont * pWpyFont;
	PyObject * pybrush;

	PyObject * view = PyObject_GetAttrString(pydc, "wpyParent");
	ASSERT(view);
	pybrush = PyObject_GetAttrString(view, "wpyBrush");
	if (pybrush){
		if (pBrush = (CBrush *)theApp.GetCppObject(pybrush)){
			LOGBRUSH lb;
			pBrush->GetObject(sizeof(LOGBRUSH), &lb);
			pDC->SetBkColor(lb.lbColor);
		}
	}
	else
		PyErr_Clear();
	Py_XDECREF(view);
	Py_XDECREF(pybrush);

	PyObject * pypen = PyObject_GetAttrString(pydc, "wpyPen");
	if (!pypen)
		PyErr_Clear();
	if (pypen && (pPen = (CPen *)theApp.GetCppObject(pypen)))
			pDC->SelectObject(pPen);
	Py_XDECREF(pypen);
	pybrush = PyObject_GetAttrString(pydc, "wpyBrush");
	if (!pybrush)
		PyErr_Clear();
	if (pybrush && (pBrush = (CBrush *)theApp.GetCppObject(pybrush)))
			pDC->SelectObject(pBrush);
	Py_XDECREF(pybrush);
	PyObject * pyfont = PyObject_GetAttrString(pydc, "wpyFont");
	if (!pyfont)
		PyErr_Clear();
	if (pyfont && (pWpyFont = (CWpyFont *)theApp.GetCppObject(pyfont)))
			pWpyFont->SelectFont(pDC);
	Py_XDECREF(pyfont);
	PyObject * pycolor = PyObject_GetAttrString(pydc, "wpyTextColor");
	if (pycolor){
		PyObject * py = PyTuple_GetItem(pycolor, 0);
		ASSERT(py);
		long r = PyInt_AsLong(py);
		py = PyTuple_GetItem(pycolor, 1);
		ASSERT(py);
		long g = PyInt_AsLong(py);
		py = PyTuple_GetItem(pycolor, 2);
		ASSERT(py);
		long b = PyInt_AsLong(py);
		pDC->SetTextColor(RGB(r, g, b));
	}
	else
		PyErr_Clear();
	Py_XDECREF(pycolor);
}

PyObject *CWpythonApp::WpyResetDC(PyObject *self, PyObject *args)
{
	PyObject *pydc;
	long portrait;
	if (!PyArg_Parse (args, "(Ol)", &pydc, &portrait))
		return NULL;
	long val;
	if (!::GetAttrLong(pydc, "wpyphysDC", &val) || !val){
		PyErr_SetString(PyExc_NameError, "Device context is invalid");
		return NULL;
	}
	CDC * pDC = (CDC *) val;
	int ret = 0;
	if (m_hDevMode) {
		DEVMODE * pDevMode = (DEVMODE *)::GlobalLock(m_hDevMode);
		if (pDevMode) {
			if (portrait)
				pDevMode->dmOrientation = DMORIENT_PORTRAIT;
			else
				pDevMode->dmOrientation = DMORIENT_LANDSCAPE;
			pDevMode->dmFields = 0x01;
			ret = pDC->ResetDC(pDevMode);
			::GlobalUnlock(m_hDevMode);
		}
	}
	PyObject * pyret = Py_BuildValue("i", ret);
	return pyret;
}

void CWpythonApp::WinHelp(DWORD dwData, UINT nCmd)
{
	long value;
	PyObject * pyobj = GetPythonControl(dwData);
	if (pyobj) {	// Help for control
		if (GetAttrLong(pyobj, "nHelpID", &value))
			CWinApp::WinHelp(value, nCmd);
	}
	else {
		CWnd * pWnd = m_pMainWnd->GetActiveWindow();
		pyobj = GetPythonObject(pWnd);
		if (pyobj) {	// Help for window
			if (GetAttrLong(pyobj, "nHelpID", &value)) {
				CWinApp::WinHelp(value, nCmd);
			}
			else {
				PyObject * ret = CallPythonRet(pyobj, "OnHelp", NULL);
				if (ret && PyInt_Check(ret)) {
					value = PyInt_AsLong(ret);
					CWinApp::WinHelp(value, nCmd);
				}
				Py_XDECREF(ret);
			}
		}
	}
}
